% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hindcast.mvgam.R
\name{hindcast.mvgam}
\alias{hindcast.mvgam}
\alias{hindcast}
\title{Extract hindcasts for a fitted \code{mvgam} object}
\usage{
hindcast(object, ...)

\method{hindcast}{mvgam}(object, type = "response", ...)
}
\arguments{
\item{object}{\code{list} object of class \code{mvgam} or \code{jsdgam}.
See \code{\link[=mvgam]{mvgam()}}}

\item{...}{Ignored}

\item{type}{When this has the value \code{link} (default) the linear
predictor is calculated on the link scale. If \code{expected} is used,
predictions reflect the expectation of the response (the mean) but ignore
uncertainty in the observation process. When \code{response} is used, the
predictions take uncertainty in the observation process into account to
return predictions on the outcome scale. When \code{variance} is used, the
variance of the response with respect to the mean (mean-variance
relationship) is returned. When \code{type = "terms"}, each component of the
linear predictor is returned separately in the form of a \code{list} (possibly
with standard errors, if \code{summary = TRUE}): this includes parametric model
components, followed by each smooth component, but excludes any offset and
any intercept. Two special cases are also allowed: type \code{latent_N} will
return the estimated latent abundances from an N-mixture distribution,
while type \code{detection} will return the estimated detection probability from
an N-mixture distribution}
}
\value{
An object of class \code{mvgam_forecast} containing hindcast distributions.
See \code{\link{mvgam_forecast-class}} for details.
}
\description{
Extract hindcasts for a fitted \code{mvgam} object
}
\details{
Posterior hindcasts (i.e. retrodictions) are drawn from the fitted \code{mvgam} and
organized into a convenient format for plotting
}
\examples{
\donttest{
simdat <- sim_mvgam(n_series = 3, trend_model = AR())
mod <- mvgam(y ~ s(season, bs = 'cc'),
             trend_model = AR(),
             noncentred = TRUE,
             data = simdat$data_train,
             chains = 2,
             silent = 2)

# Hindcasts on response scale
hc <- hindcast(mod)
str(hc)
head(summary(hc), 12)
plot(hc, series = 1)
plot(hc, series = 2)
plot(hc, series = 3)

# Hindcasts as expectations
hc <- hindcast(mod, type = 'expected')
head(summary(hc), 12)
plot(hc, series = 1)
plot(hc, series = 2)
plot(hc, series = 3)

# Estimated latent trends
hc <- hindcast(mod, type = 'trend')
head(summary(hc), 12)
plot(hc, series = 1)
plot(hc, series = 2)
plot(hc, series = 3)
}
}
\seealso{
\code{\link[=plot.mvgam_forecast]{plot.mvgam_forecast()}}, \code{\link[=summary.mvgam_forecast]{summary.mvgam_forecast()}},
\code{\link[=forecast.mvgam]{forecast.mvgam()}}, \code{\link[=fitted.mvgam]{fitted.mvgam()}}, \code{\link[=predict.mvgam]{predict.mvgam()}}
}
