% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twoway_projector.R
\name{inverse_projection.cross_projector}
\alias{inverse_projection.cross_projector}
\title{Default inverse_projection method for cross_projector}
\usage{
\method{inverse_projection}{cross_projector}(x, domain = c("X", "Y"), ...)
}
\arguments{
\item{x}{A \code{cross_projector} object.}

\item{domain}{Either \code{"X"} or \code{"Y"}, indicating which block's inverse
loading matrix we want (i.e., if you want to reconstruct data in the
X space or Y space).}

\item{...}{Additional arguments (currently unused, but may be used by subclasses).}
}
\value{
A matrix that, when multiplied by the factor scores, yields the
reconstruction in the specified domain's original space.
}
\description{
This function obtains the matrix that maps factor scores in the
latent space back into the original domain (X or Y). By default,
we assume \code{v_domain} is \emph{not} necessarily orthonormal or invertible,
so we use a pseudoinverse approach (e.g. MASS::ginv).
}
\examples{
# Suppose 'cp' is a cross_projector object. If we want the
# inverse for the Y domain:
#   inv_mat <- inverse_projection(cp, domain="Y")
# Then reconstruct:  Yhat <- Fscores \%*\% inv_mat
}
