% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TorchOptimizer.R
\docType{data}
\name{mlr3torch_optimizers}
\alias{mlr3torch_optimizers}
\title{Optimizers}
\format{
An object of class \code{DictionaryMlr3torchOptimizers} (inherits from \code{Dictionary}, \code{R6}) of length 12.
}
\usage{
mlr3torch_optimizers
}
\description{
Dictionary of torch optimizers.
Use \code{\link{t_opt}} for conveniently retrieving optimizers.
Can be converted to a \code{\link[data.table:data.table]{data.table}} using
\code{\link[data.table:as.data.table]{as.data.table}}.
}
\section{Available Optimizers}{

adagrad, adam, adamw, rmsprop, sgd
}

\examples{
\dontshow{if (torch::torch_is_installed()) withAutoprint(\{ # examplesIf}
mlr3torch_optimizers$get("adam")
# is equivalent to
t_opt("adam")
# convert to a data.table
as.data.table(mlr3torch_optimizers)
\dontshow{\}) # examplesIf}
}
\seealso{
Other Torch Descriptor: 
\code{\link{TorchCallback}},
\code{\link{TorchDescriptor}},
\code{\link{TorchLoss}},
\code{\link{TorchOptimizer}},
\code{\link{as_torch_callbacks}()},
\code{\link{as_torch_loss}()},
\code{\link{as_torch_optimizer}()},
\code{\link{mlr3torch_losses}},
\code{\link{t_clbk}()},
\code{\link{t_loss}()},
\code{\link{t_opt}()}

Other Dictionary: 
\code{\link{mlr3torch_callbacks}},
\code{\link{mlr3torch_losses}},
\code{\link{t_opt}()}
}
\concept{Dictionary}
\concept{Torch Descriptor}
\keyword{datasets}
