% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracking-observer.R
\name{mlflow_register_external_observer}
\alias{mlflow_register_external_observer}
\title{Register an external MLflow observer}
\usage{
mlflow_register_external_observer(observer)
}
\arguments{
\item{observer}{The observer object (see example)}
}
\description{
Registers an external MLflow observer that will receive a
`register_tracking_event(event_name, data)` callback on any model tracking
event such as "create_run", "delete_run", or "log_metric".
Each observer should have a `register_tracking_event(event_name, data)`
callback accepting a character vector `event_name` specifying the name of
the tracking event, and `data` containing a list of attributes of the event.
The callback should be non-blocking, and ideally should complete
 instantaneously. Any exception thrown from the callback will be ignored.
}
\examples{

library(mlflow)

observer <- structure(list())
observer$register_tracking_event <- function(event_name, data) {
  print(event_name)
  print(data)
}
mlflow_register_external_observer(observer)

}
