% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracking-ui.R
\name{mlflow_ui}
\alias{mlflow_ui}
\title{Run MLflow User Interface}
\usage{
mlflow_ui(client, ...)
}
\arguments{
\item{client}{(Optional) An MLflow client object returned from \link[mlflow]{mlflow_client}.
If specified, MLflow will use the tracking server associated with the passed-in client. If
unspecified (the common case),
MLflow will use the tracking server associated with the current tracking URI.}

\item{...}{Optional arguments passed to `mlflow_server()` when `x` is a path to a file store.}
}
\description{
Launches the MLflow user interface.
}
\examples{
\dontrun{
library(mlflow)

# launch mlflow ui locally
mlflow_ui()

# launch mlflow ui for existing mlflow server
mlflow_set_tracking_uri("http://tracking-server:5000")
mlflow_ui()
}

}
