# WARNING - Generated by {fusen} from dev/flat_teaching.Rmd: do not edit by hand

# Test basic formatting functionality
test_that("format_digits performs basic number formatting correctly", {
  df <- data.table(
    a = c(1.234, 2.345),
    b = c(3.456, 4.567),
    c = c("text1", "text2")
  )
  
  # Test default formatting
  result <- format_digits(df, cols = c("a", "b"))
  expect_equal(result$a, c("1.23", "2.35"))
  expect_equal(result$b, c("3.46", "4.57"))
  expect_equal(result$c, c("text1", "text2"))
  
  # Test different digits
  result <- format_digits(df, cols = "a", digits = 1)
  expect_equal(result$a, c("1.2", "2.3"))
  
  # Test percentage formatting
  result <- format_digits(df, cols = "a", percentage = TRUE)
  expect_equal(result$a, c("123.40%", "234.50%"))
})

# Test automatic column detection
test_that("format_digits handles automatic numeric column detection", {
  df <- data.table(
    num1 = c(1.234, 2.345),
    num2 = c(3.456, 4.567),
    text = c("a", "b")
  )
  
  result <- format_digits(df)
  expect_equal(result$num1, c("1.23", "2.35"))
  expect_equal(result$num2, c("3.46", "4.57"))
  expect_equal(result$text, c("a", "b"))
})

# Test input validation
test_that("format_digits validates input parameters correctly", {
  df <- data.table(x = 1.234)
  
  # Test invalid data input
  expect_error(format_digits(1:3), "Input data must be a data.frame or data.table object")
  
  # Test invalid cols parameter
  expect_error(format_digits(df, cols = list()), "'cols' must be numeric or character vector")
  expect_error(format_digits(df, cols = character(0)), "When specified, 'cols' cannot be empty")
  expect_error(format_digits(df, cols = "nonexistent"), "Following columns do not exist")
  expect_error(format_digits(df, cols = 0), "Numeric column indices must be between")
  
  # Test invalid digits parameter
  expect_error(format_digits(df, digits = -1), "'digits' must be a single non-negative integer")
  expect_error(format_digits(df, digits = c(1,2)), "'digits' must be a single non-negative integer")
  expect_error(format_digits(df, digits = 1.5), "'digits' must be a single non-negative integer")
})

# Test data type handling
test_that("format_digits handles different data types correctly", {
  df <- data.table(
    int = c(1L, 2L),
    dbl = c(1.23, 4.56),
    chr = c("7.89", "0.12")
  )
  
  result <- format_digits(df)
  expect_equal(result$int, c("1.00", "2.00"))
  expect_equal(result$dbl, c("1.23", "4.56"))
  expect_equal(result$chr, c("7.89", "0.12"))
})

# Test special cases
test_that("format_digits handles special cases correctly", {
  df <- data.table(
    x = c(0, 999999.999),
    y = c(NA, 1.23),
    z = c(Inf, -Inf)
  )
  
  result <- format_digits(df)
  expect_equal(result$x, c("0.00", "1000000.00"))
  expect_equal(result$y[1], "NA")
  expect_equal(result$y[2], "1.23")
  expect_equal(result$z, c("Inf", "-Inf"))
})

# Test data.frame conversion
test_that("format_digits handles data.frame to data.table conversion", {
  df <- data.frame(
    x = c(1.234, 2.345),
    y = c("a", "b")
  )
  
  result <- format_digits(df)
  expect_true(is.data.table(result))
  expect_equal(result$x, c("1.23", "2.35"))
  expect_equal(result$y, c("a", "b"))
})

