% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_color_theme.R
\name{set.color.theme}
\alias{set.color.theme}
\title{Register Color Themes}
\usage{
set.color.theme(
  kernel,
  kernel.args = list(),
  options = list(),
  name = "newtheme",
  source = "custom",
  type = NULL,
  env = color.theme.env()
)
}
\arguments{
\item{kernel}{a color vector, a palette function, or a ramp function to be used as a color kernel. It can also be a character vector or a list (see the "Details" section). A "color.theme" object can also be passed.}

\item{kernel.args}{a list of arguments to be passed to the color kernel.}

\item{options}{a list of option values to control the color theme's behavior.}

\item{name}{a character string for the color theme name.}

\item{source}{a character string for the source name of the color theme.}

\item{type}{a character string specifying the type of the color theme. One of "sequential", "diverging", or "qualitative".}

\item{env}{an environment where the color themes are registered.}
}
\value{
\code{set.color.theme()} returns the metadata of the previous theme that was overwritten (or \code{NULL} if none existed) invisibly.
}
\description{
\code{set.color.theme()} registers a custom color theme in the package's theme registry.
}
\details{
This function takes a color vector, a color-generating function, or an existing "color.theme" object and registers it under a specified \code{name} and \code{source} (default is "custom/newtheme").
The registered color theme can then be easily retrieved using the "Theme Name Syntax" (see \code{help(color.theme)}).

To keep the registry environment size small, the \code{kernel} argument supports a form of lazy loading.
To use this feature, provide a vector or list containing two character strings.
The first is an R expression that returns a color kernel (e.g., "rainbow"), and the second is the namespace in which to evaluate the expression (e.g., "grDevices").
The expression is evaluated only when the color theme is loaded by \code{color.theme()}.
}
\seealso{
\code{\link{color.theme}}, \code{\link{color.theme.info}}
}
