% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mid_conditional.R
\name{plot.mid.conditional}
\alias{plot.mid.conditional}
\title{Plot MID Conditional Expectations}
\usage{
\method{plot}{mid.conditional}(
  x,
  type = c("iceplot", "centered"),
  theme = NULL,
  term = NULL,
  var.alpha = NULL,
  var.color = NULL,
  var.linetype = NULL,
  var.linewidth = NULL,
  reference = 1L,
  dots = TRUE,
  sample = NULL,
  ...
)
}
\arguments{
\item{x}{a "mid.conditional" object to be visualized.}

\item{type}{the plotting style. One of "iceplot" or "centered".}

\item{theme}{a character string or object defining the color theme. See \code{\link{color.theme}} for details.}

\item{term}{an optional character string specifying an interaction term. If passed, the ICE curve for the specified term is plotted.}

\item{var.alpha}{a variable name or expression to map to the alpha aesthetic.}

\item{var.color}{a variable name or expression to map to the color aesthetic.}

\item{var.linetype}{a variable name or expression to map to the linetype aesthetic.}

\item{var.linewidth}{a variable name or expression to map to the linewidth aesthetic.}

\item{reference}{an integer specifying the index of the sample points to use as the reference for centering the c-ICE plot.}

\item{dots}{logical. If \code{TRUE}, points representing the actual predictions for each observation are plotted.}

\item{sample}{an optional vector specifying the names of observations to be plotted.}

\item{...}{optional parameters passed on to the graphing functions.}
}
\value{
\code{plot.mid.conditional()} produces an ICE plot as a side-effect and invisibly returns the ICE matrix used for the plot.
}
\description{
For "mid.conditional" objects, \code{plot()} visualizes Individual Conditional Expectation (ICE) curves derived from a fitted MID model.
}
\details{
This is an S3 method for the \code{plot()} generic that produces ICE curves from a "mid.conditional" object.
ICE plots are a model-agnostic tool for visualizing how a model's prediction for a single observation changes as one feature varies.
This function plots one line for each observation in the data.

The \code{type} argument controls the visualization style:
The default, \code{type = "iceplot"}, plots the row ICE curves.
The \code{type = "centered"} option creates the centered ICE (c-ICE) plot, where each curve is shifted so start at zero, which makes it easier to compare the slopes of the curves.

The \code{var.color}, \code{var.alpha}, etc., arguments allow you to map aesthetics to other variables in your data using (possibly) unquoted expressions.
}
\examples{
data(airquality, package = "datasets")
library(midr)
mid <- interpret(Ozone ~ .^2, data = airquality, lambda = 0.1)
ice <- mid.conditional(mid, "Temp", data = airquality)

# Create an ICE plot, coloring lines by 'Wind'
plot(ice, var.color = "Wind")

# Create a centered ICE plot, mapping color and linetype to other variables
plot(ice, type = "centered", theme = "Purple-Yellow",
     var.color = factor(Month), var.linetype = Wind > 10)
}
\seealso{
\code{\link{mid.conditional}}, \code{\link{ggmid.mid.conditional}}
}
