% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{centerscale}
\alias{centerscale}
\title{Center and scale vector}
\usage{
centerscale(
  v,
  type = c("center", "auto", "range", "iqrange", "vast", "pareto", "level", "none"),
  na.rm = FALSE,
  zero_action = c("zeros", "unscaled", "fill"),
  zero_fill = 0.5
)
}
\arguments{
\item{v}{A numeric vector to center and scale.}

\item{type}{Type of scaling. One of:
\itemize{
  \item \code{"center"}: subtract mean.
  \item \code{"auto"}: subtract mean and divide by standard deviation.
  \item \code{"range"}: subtract mean and divide by range.
  \item \code{"iqrange"}: subtract median and divide by interquartile range
    (MATLAB-compatible, type = 5).
  \item \code{"vast"}: variance-stabilizing transformation.
  \item \code{"pareto"}: subtract mean and divide by square root of standard
    deviation.
  \item \code{"level"}: subtract mean and divide by mean.
  \item \code{"none"}: return input unchanged.
}}

\item{na.rm}{Logical; if \code{TRUE}, remove missing values before computing
statistics (mean, sd, var, range, etc.).}

\item{zero_action}{Policy when denominator is zero or invalid. One of:
\itemize{
  \item \code{"zeros"}: return a vector of zeros (default).
  \item \code{"unscaled"}: return the original vector unscaled.
  \item \code{"fill"}: return a constant vector with value given by
    \code{zero_fill}.
}}

\item{zero_fill}{Numeric value to use when \code{zero_action = "fill"}.}
}
\value{
A numeric vector of the same length as \code{v}, centered and scaled
according to the specified method and zero-denominator policy.
}
\description{
Center and scale an input vector using the specified method. Several scaling
approaches are supported, including mean-centering, autoscaling (unit
variance), range scaling, interquartile range scaling, vast, Pareto, and
level scaling. A fallback policy can be specified for cases where the
denominator is zero or invalid (e.g. constant vectors).
}
\details{
Warnings are issued when the denominator is zero or invalid and the
\code{zero_action} policy is applied.
}
\examples{

v <- c(-100, 3, 4, 500, 10, 25, -8, -33, 321, 0, 2)

centerscale(v, "center")
# [1] -165.81818  -62.81818  -61.81818  434.18182  -55.81818  -40.81818
# [7]  -73.81818  -98.81818  255.18182  -65.81818  -63.81818

centerscale(v, "auto")
# [1] -0.9308937 -0.3526577 -0.3470437  2.4374717 -0.3133601 -0.2291509
# [7] -0.4144110 -0.5547596  1.4325760 -0.3694995 -0.3582716

centerscale(v, "range")
# [1] -0.2763636 -0.1046970 -0.1030303  0.7236364 -0.0930303 -0.0680303
# [7] -0.1230303 -0.1646970  0.4253030 -0.1096970 -0.1063636

centerscale(v, "iqrange")
# [1] -6.085071 -2.305254 -2.268557 15.933278 -2.048374 -1.497915 -2.708924
# [8] -3.626355  9.364470 -2.415346 -2.341952

centerscale(v, "vast")
# [1] -0.34396474 -0.13030682 -0.12823247  0.90064453 -0.11578638 -0.08467115
# [7] -0.15312466 -0.20498338  0.52933609 -0.13652987 -0.13238117

centerscale(v, "pareto")
# [1] -12.424134  -4.706731  -4.631804  32.531614  -4.182247  -3.058353
# [7]  -5.530919  -7.404075  19.119816  -4.931509  -4.781657

centerscale(v, "level")
# [1] -2.5193370 -0.9544199 -0.9392265  6.5966851 -0.8480663 -0.6201657
# [7] -1.1215470 -1.5013812  3.8770718 -1.0000000 -0.9696133

centerscale(v, "none")
# [1] -100    3    4  500   10   25   -8  -33  321    0    2

# The following examples will throw warnings due to the vector being constant

w <- c(5, 5, 5)
centerscale(w, "auto")
# [1] 0 0 0

centerscale(w, "range", zero_action="unscaled")
# [1] 5 5 5

centerscale(w, "range", zero_action="fill", zero_fill=0.5)
# [1] 0.5 0.5 0.5

}
\references{
Berg, R., Hoefsloot, H., Westerhuis, J., Smilde, A., and Werf, M.
(2006). Centering, scaling, and transformations: improving the biological
information content of metabolomics data. \emph{BMC Genomics} \bold{7}, 142.
DOI: 10.1186/1471-2164-7-142
}
