% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ABCXYZanalysis.R
\docType{methods}
\name{summary,ABCXYZComparison-method}
\alias{summary,ABCXYZComparison-method}
\title{Prints the summary of the comparison of two ABC/XYZ analyses}
\usage{
\S4method{summary}{ABCXYZComparison}(object, withMissing = FALSE)
}
\arguments{
\item{object}{Object of class ABCXYZComparison.}

\item{withMissing}{Logical indicating whether missing categories will be shown. Default is \code{FALSE}.}
}
\value{
A contingency table showing the differences.
}
\description{
Summarizes the differences between two \code{ABCXYZData} objects.
}
\examples{
data("Amount")
data1 = Amount[sample(1:nrow(Amount), 1000),]
data2 = Amount[sample(1:nrow(Amount), 1000),]
abcxyzData1 = computeABCXYZAnalysis(data1, value = "value", item = "item", timestamp = "date",
                                    temporalAggregation = "day", XY = 0.5, YZ = 1)
abcxyzData2 = computeABCXYZAnalysis(data2, value = "value", item = "item", timestamp = "date",
                                    temporalAggregation = "day", XY = 0.5, YZ = 1)
comparison = compare(abcxyzData1, abcxyzData2)
summary(comparison)
}
\seealso{
\code{\link[=ABCXYZComparison-class]{compare}} \code{\link[=ABCXYZComparison-class]{ABCXYZComparison}}
}
\author{
Leon Binder \email{leon.binder@th-deg.de}

Bernhard Bauer \email{bernhard.bauer@th-deg.de}

Michael Scholz \email{michael.scholz@th-deg.de}
}
\keyword{methods}
