/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.structure.iterators;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.structure.IndexedObject;

public final class BipartiteSetIterator
extends DisposableIntIterator {
    private int[] list;
    private int[] position;
    private IndexedObject[] idxToObjects;
    private IStateInt last;
    private int nlast;
    private int idx;

    public void init(int[] aList, int[] aPosition, IStateInt aLast, IndexedObject[] anIdxToObjects) {
        this.idx = 0;
        this.list = aList;
        this.position = aPosition;
        this.idxToObjects = anIdxToObjects;
        this.last = aLast;
        this.nlast = this.last.get();
    }

    @Override
    public boolean hasNext() {
        return this.idx <= this.nlast;
    }

    @Override
    public int next() {
        return this.list[this.idx++];
    }

    public IndexedObject nextObject() {
        return this.idxToObjects[this.list[this.idx++]];
    }

    @Override
    public void remove() {
        --this.idx;
        int idxToRem = this.idx;
        if (idxToRem == this.nlast) {
            this.last.add(-1);
            --this.nlast;
        } else {
            int temp = this.list[this.nlast];
            this.list[this.nlast] = this.list[idxToRem];
            this.list[idxToRem] = temp;
            this.position[this.list[this.nlast]] = this.last.get();
            this.position[temp] = idxToRem;
            this.last.add(-1);
            --this.nlast;
        }
    }
}

