sanity_predict_vector <- function(pred, model, newdata, type) {
    if (
        !isTRUE(checkmate::check_atomic_vector(pred)) &&
            !isTRUE(checkmate::check_array(pred, d = 1))
    ) {
        msg <- sprintf(
            '`predict(model, type = "%s")` was called on a model of class `%s`, but this command did not produce the expected outcome: A numeric vector of length %s. This can sometimes happen when users try compute a marginal effect for some models with grouped or multivariate outcome which are not supported yet by `marginaleffects` package. Please consult your modeling package documentation to learn what alternative `type` arguments are accepted by the `predict` method, or file a feature request on Github:  https://github.com/vincentarelbundock/marginaleffects/issues',
            type,
            class(model)[1],
            nrow(newdata)
        )
        stop(msg, call. = FALSE)
    }
}


sanity_predict_numeric <- function(pred, model, newdata, type) {
    if (!isTRUE(checkmate::check_numeric(pred))) {
        msg <- sprintf(
            '`predict(model, type = "%s")` was called on a model of class `%s`, but this command did not produce the expected outcome: A numeric vector of length %s. This can sometimes happen when users try compute a marginal effect for an outcome type which is unsupported, or which cannot be differentiated. Please consult your modeling package documentation to learn what alternative `type` arguments are accepted by the `predict` method.',
            type,
            class(model)[1],
            nrow(newdata)
        )
        stop(msg, call. = FALSE)
    }
}
