% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp-get-munic.R
\encoding{UTF-8}
\name{esp_get_munic}
\alias{esp_get_munic}
\title{Municipalities of Spain - GISCO}
\source{
\url{https://gisco-services.ec.europa.eu/distribution/v2/}.

Copyright:
\url{https://ec.europa.eu/eurostat/web/gisco/geodata/statistical-units}.
}
\usage{
esp_get_munic(
  year = 2024,
  epsg = 4258,
  cache = deprecated(),
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  region = NULL,
  munic = NULL,
  moveCAN = TRUE,
  ext = "gpkg"
)
}
\arguments{
\item{year}{year character string or number. Release year of the file. See
\code{\link[giscoR:gisco_get_lau]{giscoR::gisco_get_lau()}} and \code{\link[giscoR:gisco_get_communes]{giscoR::gisco_get_communes()}} for valid
values.}

\item{epsg}{character string or number. Projection of the map: 4-digit
\href{https://epsg.io/}{EPSG code}. One of:
\itemize{
\item \code{"4258"}: \href{https://epsg.io/4258}{ETRS89}
\item \code{"4326"}: \href{https://epsg.io/4326}{WGS84}.
\item \code{"3035"}: \href{https://epsg.io/3035}{ETRS89 / ETRS-LAEA}.
\item \code{"3857"}: \href{https://epsg.io/3857}{Pseudo-Mercator}.
}}

\item{cache}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}. This argument is
deprecated, the dataset will always be downloaded to the \code{cache_dir}.}

\item{update_cache}{logical. Should the cached file be refreshed? Default
is \code{FALSE}. When set to \code{TRUE}, it will force a new download.}

\item{cache_dir}{character string. A path to a cache directory. See
\strong{Caching strategies} section in \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}

\item{region}{Optional. A vector of region names, NUTS or ISO codes
(see \code{\link[=esp_dict_region_code]{esp_dict_region_code()}}).}

\item{munic}{character string. A name or \code{\link[base:grep]{regex}} expression
with the names of the required municipalities. \code{NULL} will return all
municipalities.}

\item{moveCAN}{A logical \code{TRUE/FALSE} or a vector of coordinates
\code{c(lat, lon)}. It places the Canary Islands close to Spain's mainland.
Initial position can be adjusted using the vector of coordinates. See
\strong{Displacing the Canary Islands} in \code{\link[=esp_move_can]{esp_move_can()}}.}

\item{ext}{character. Extension of the file (default \code{"gpkg"}). See
\code{\link[giscoR:gisco_get_nuts]{giscoR::gisco_get_nuts()}}.}
}
\value{
A \code{\link[sf:sf]{sf}} object.
}
\description{
This dataset shows boundaries of municipalities in Spain.
}
\details{
When using \code{region} you can use and mix names and NUTS codes (levels 1, 2 or
3), ISO codes (corresponding to level 2 or 3) or \code{"cpro"}
(see \link{esp_codelist}).

When calling a higher level (province, CCAA or NUTS1), all the municipalities
of that level will be added.
}
\section{Note}{

Please check the download and usage provisions on \code{\link[giscoR:gisco_attributions]{gisco_attributions()}}.

}

\examples{
\dontshow{if (esp_check_access()) withAutoprint(\{ # examplesIf}
\donttest{
# The Spanish Lapland:
# https://en.wikipedia.org/wiki/Celtiberian_Range

# Get munics
spanish_laplad <- esp_get_munic(
  year = 2023,
  region = c(
    "Cuenca", "Teruel",
    "Zaragoza", "Guadalajara",
    "Soria", "Burgos",
    "La Rioja"
  )
)

breaks <- sort(c(0, 5, 10, 50, 100, 200, 500, 1000, Inf))
spanish_laplad$dens_breaks <- cut(spanish_laplad$POP_DENS_2023, breaks,
  dig.lab = 20
)

cut_labs <- prettyNum(breaks, big.mark = " ")[-1]
cut_labs[length(breaks)] <- "> 1000"

library(ggplot2)
ggplot(spanish_laplad) +
  geom_sf(aes(fill = dens_breaks), color = "grey30", linewidth = 0.1) +
  scale_fill_manual(
    values = hcl.colors(length(breaks) - 1, "Spectral"), na.value = "black",
    name = "people per sq. kilometer",
    labels = cut_labs,
    guide = guide_legend(
      direction = "horizontal",
      nrow = 1
    )
  ) +
  theme_void() +
  labs(
    title = "The Spanish Lapland",
    caption = giscoR::gisco_attributions()
  ) +
  theme(
    text = element_text(colour = "white"),
    plot.background = element_rect(fill = "grey2"),
    plot.title = element_text(hjust = 0.5),
    plot.subtitle = element_text(hjust = 0.5, face = "bold"),
    plot.caption = element_text(
      color = "grey60", hjust = 0.5, vjust = 0,
      margin = margin(t = 5, b = 10)
    ),
    legend.position = "bottom",
    legend.title.position = "top",
    legend.text.position = "bottom",
    legend.key.height = unit(0.5, "lines"),
    legend.key.width = unit(1, "lines")
  )
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[giscoR:gisco_get_lau]{giscoR::gisco_get_lau()}}, \code{\link[giscoR:gisco_get_communes]{giscoR::gisco_get_communes()}}.

Other datasets representing political borders:
\code{\link{esp_get_capimun}()},
\code{\link{esp_get_ccaa}()},
\code{\link{esp_get_ccaa_siane}()},
\code{\link{esp_get_comarca}()},
\code{\link{esp_get_countries_siane}()},
\code{\link{esp_get_gridmap}},
\code{\link{esp_get_munic_siane}()},
\code{\link{esp_get_nuts}()},
\code{\link{esp_get_prov}()},
\code{\link{esp_get_prov_siane}()},
\code{\link{esp_get_simpl}},
\code{\link{esp_get_spain}()},
\code{\link{esp_get_spain_siane}()},
\code{\link{esp_siane_bulk_download}()}

Datasets representing municipalities:
\code{\link{esp_get_capimun}()},
\code{\link{esp_get_munic_siane}()}

Datasets provided by GISCO:
\code{\link{esp_get_ccaa}()},
\code{\link{esp_get_nuts}()},
\code{\link{esp_get_prov}()},
\code{\link{esp_get_spain}()}
}
\concept{gisco}
\concept{municipalities}
\concept{political}
