% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_cohesion.R
\name{measure_cohesion}
\alias{measure_cohesion}
\alias{net_density}
\alias{net_components}
\alias{net_cohesion}
\alias{net_adhesion}
\alias{net_diameter}
\alias{net_length}
\alias{net_independence}
\alias{net_strength}
\alias{net_toughness}
\title{Measures of network cohesion or connectedness}
\usage{
net_density(.data)

net_components(.data)

net_cohesion(.data)

net_adhesion(.data)

net_diameter(.data)

net_length(.data)

net_independence(.data)

net_strength(.data)

net_toughness(.data)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}
}
\description{
These functions return values or vectors relating to how connected a network is
and the number of nodes or edges to remove that would increase fragmentation.
\itemize{
\item \code{net_density()} measures the ratio of ties to the number
of possible ties.
\item \code{net_components()} measures the number of (strong) components
in the network.
\item \code{net_cohesion()} measures the minimum number of nodes to remove
from the network needed to increase the number of components.
\item \code{net_adhesion()} measures the minimum number of ties to remove
from the network needed to increase the number of components.
\item \code{net_diameter()} measures the maximum path length in the network.
\item \code{net_length()} measures the average path length in the network.
\item \code{net_independence()} measures the independence number,
or size of the largest independent set in the network.
\item \code{net_strength()} measures the number of ties that would need to be
removed from a network to increase its number of components.
\item \code{net_toughness()} measures the number of nodes that would need to be
removed from a network to increase its number of components.
}
}
\section{Cohesion}{

To get the 'weak' components of a directed graph,
please use \code{manynet::to_undirected()} first.
}

\examples{
net_density(ison_adolescents)
net_density(ison_southern_women)
  net_components(fict_thrones)
  net_components(to_undirected(fict_thrones))
net_cohesion(ison_marvel_relationships)
net_cohesion(to_giant(ison_marvel_relationships))
net_adhesion(ison_marvel_relationships)
net_adhesion(to_giant(ison_marvel_relationships))
net_diameter(ison_marvel_relationships)
net_diameter(to_giant(ison_marvel_relationships))
net_length(ison_marvel_relationships)
net_length(to_giant(ison_marvel_relationships))
net_independence(ison_adolescents)
net_strength(ison_adolescents)
net_toughness(ison_adolescents)
}
\references{
\subsection{On cohesion}{

White, Douglas R and Frank Harary. 2001.
"The Cohesiveness of Blocks In Social Networks: Node Connectivity and Conditional Density."
\emph{Sociological Methodology} 31(1): 305-59.
\doi{10.1111/0081-1750.00098}
}
}
\seealso{
Other measures: 
\code{\link{measure_attributes}},
\code{\link{measure_central_between}},
\code{\link{measure_central_close}},
\code{\link{measure_central_degree}},
\code{\link{measure_central_eigen}},
\code{\link{measure_closure}},
\code{\link{measure_diffusion_infection}},
\code{\link{measure_diffusion_net}},
\code{\link{measure_diffusion_node}},
\code{\link{measure_features}},
\code{\link{measure_heterogeneity}},
\code{\link{measure_hierarchy}},
\code{\link{measure_holes}},
\code{\link{measure_periods}},
\code{\link{measure_properties}},
\code{\link{member_diffusion}}
}
\concept{measures}
