% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet-rep-lab.r, R/facet-wrap.r
\name{facet_rep_grid}
\alias{facet_rep_grid}
\alias{facet_rep_wrap}
\title{Repeat axis lines and labels across all facet panels}
\usage{
facet_rep_grid(..., repeat.tick.labels = FALSE)

facet_rep_wrap(..., scales = "fixed", repeat.tick.labels = FALSE)
}
\arguments{
\item{...}{Arguments used for \code{\link[ggplot2]{facet_grid}} or
\code{\link[ggplot2]{facet_wrap}}.}

\item{repeat.tick.labels}{When \code{FALSE} (default), axes on inner panels
have their tick labels (i.e. the numbers) removed.
Set this to \code{TRUE} to keep all labels,
or any combination of top, bottom, left, right to
keep only those specified. Also acceps 'x' and 'y'.}

\item{scales}{As for \code{facet_grid}, but alters behaviour of \code{repeat.tick.labels}.}
}
\description{
\code{\link[ggplot2]{facet_grid}} and \code{\link[ggplot2]{facet_wrap}}, but
with axis lines and labels preserved on all panels.
These extensions have been deprecated in lemon v. 0.5.1 and replacements
can be found in [ggh4x](https://teunbrand.github.io/ggh4x/articles/Facets.html).
}
\details{
These two functions are extensions to \code{\link[ggplot2]{facet_grid}}
and \code{\link[ggplot2]{facet_wrap}} that keeps axis lines, ticks, and
optionally tick labels across all panels.

Examples are given in the vignette \href{../doc/facet-rep-labels.html}{"Repeat axis lines on facet panels" vignette}.
}
