% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/divicon.R
\name{addDivicon}
\alias{addDivicon}
\title{Add DivIcon Markers to a Leaflet Map}
\usage{
addDivicon(
  map,
  lng = NULL,
  lat = NULL,
  layerId = NULL,
  group = NULL,
  popup = NULL,
  popupOptions = NULL,
  label = NULL,
  labelOptions = NULL,
  className = NULL,
  html = NULL,
  options = markerOptions(),
  clusterOptions = NULL,
  clusterId = NULL,
  divOptions = list(),
  data = getMapData(map)
)
}
\arguments{
\item{map}{the map to add awesome Markers to.}

\item{lng}{a numeric vector of longitudes, or a one-sided formula of the form
\code{~x} where \code{x} is a variable in \code{data}; by default (if not
explicitly provided), it will be automatically inferred from \code{data} by
looking for a column named \code{lng}, \code{long}, or \code{longitude}
(case-insensitively)}

\item{lat}{a vector of latitudes or a formula (similar to the \code{lng}
argument; the names \code{lat} and \code{latitude} are used when guessing
the latitude column from \code{data})}

\item{layerId}{the layer id}

\item{group}{the name of the group the newly created layers should belong to
(for \code{\link[leaflet]{clearGroup}} and \code{\link[leaflet]{addLayersControl}} purposes).
Human-friendly group names are permitted--they need not be short,
identifier-style names. Any number of layers and even different types of
layers (e.g. markers and polygons) can share the same group name.}

\item{popup}{a character vector of the HTML content for the popups (you are
recommended to escape the text using \code{\link[htmltools]{htmlEscape}()}
for security reasons)}

\item{popupOptions}{A Vector of \code{\link[leaflet]{popupOptions}} to provide popups}

\item{label}{a character vector of the HTML content for the labels}

\item{labelOptions}{A Vector of \code{\link[leaflet]{labelOptions}} to provide label
options for each label. Default \code{NULL}}

\item{className}{A single CSS class or a vector of CSS classes.}

\item{html}{A single HTML string or a vector of HTML strings.}

\item{options}{a list of extra options for tile layers, popups, paths
(circles, rectangles, polygons, ...), or other map elements}

\item{clusterOptions}{if not \code{NULL}, markers will be clustered using
\href{https://github.com/Leaflet/Leaflet.markercluster}{Leaflet.markercluster};
 you can use \code{\link[leaflet]{markerClusterOptions}()} to specify marker cluster
options}

\item{clusterId}{the id for the marker cluster layer}

\item{divOptions}{A list of extra options for Leaflet DivIcon.}

\item{data}{the data object from which the argument values are derived; by
default, it is the \code{data} object provided to \code{leaflet()}
initially, but can be overridden}
}
\value{
The modified Leaflet map object.
}
\description{
Adds customizable DivIcon markers to a Leaflet map. The function can accept either spatial
data (lines or points) in the form of a Simple Feature (sf) object or numeric vectors
for latitude and longitude coordinates. It allows for the application of custom HTML
content and CSS classes to each marker, providing high flexibility in marker design.
}
\examples{
library(sf)
library(leaflet)
library(leaflet.extras2)

# Sample data
df <- sf::st_as_sf(atlStorms2005)
df <- suppressWarnings(st_cast(df, "POINT"))
df <- df[sample(1:nrow(df), 50, replace = FALSE), ]
df$classes <- sample(x = c("myclass1", "myclass2", "myclass3"), nrow(df), replace = TRUE)
df$ID <- paste0("ID_", 1:nrow(df))

leaflet() \%>\%
  addTiles() \%>\%
  addDivicon(
    data = df,
    html = ~ paste0(
      '<div class="custom-html">',
      '<div class="title">', Name, "</div>",
      '<div class="subtitle">MaxWind: ', MaxWind, "</div>",
      "</div>"
    ),
    label = ~Name,
    layerId = ~ID,
    group = "Divicons",
    popup = ~ paste(
      "ID: ", ID, "<br>",
      "Name: ", Name, "<br>",
      "MaxWind:", MaxWind, "<br>",
      "MinPress:", MinPress
    ),
    options = markerOptions(draggable = TRUE)
  )
}
\concept{DivIcon Functions}
