% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_fit_s3.R
\docType{class}
\name{ldmppr_fit}
\alias{ldmppr_fit}
\alias{print.ldmppr_fit}
\alias{coef.ldmppr_fit}
\alias{logLik.ldmppr_fit}
\alias{summary.ldmppr_fit}
\alias{print.summary.ldmppr_fit}
\alias{plot.ldmppr_fit}
\alias{as_nloptr}
\alias{as_nloptr.ldmppr_fit}
\title{Fitted point-process model object}
\usage{
\method{print}{ldmppr_fit}(x, ...)

\method{coef}{ldmppr_fit}(object, ...)

\method{logLik}{ldmppr_fit}(object, ...)

\method{summary}{ldmppr_fit}(object, ...)

\method{print}{summary.ldmppr_fit}(x, ...)

\method{plot}{ldmppr_fit}(x, ...)

as_nloptr(x, ...)

\method{as_nloptr}{ldmppr_fit}(x, ...)
}
\arguments{
\item{x}{an object of class \code{ldmppr_fit}.}

\item{...}{additional arguments (not used).}

\item{object}{an object of class \code{ldmppr_fit}.}
}
\value{
\describe{
  \item{\code{print()}}{prints a brief summary of the fit.}
  \item{\code{coef()}}{returns the estimated parameter vector.}
  \item{\code{logLik()}}{returns the log-likelihood at the optimum.}
  \item{\code{summary()}}{returns a \code{summary.ldmppr_fit}.}
  \item{\code{plot()}}{plots diagnostics for multi-fit runs, if available.}
}
}
\description{
Objects of class \code{ldmppr_fit} are returned by \code{\link{estimate_process_parameters}}.
They contain the best-fitting optimization result (and optionally multiple fits,
e.g. from a delta search) along with metadata used to reproduce the fit.
}
\details{
A \code{ldmppr_fit} is a list with (at minimum):
\itemize{
  \item \code{process}: process name (e.g. \code{"self_correcting"})
  \item \code{fit}: best optimization result (currently an \code{nloptr} object)
  \item \code{mapping}: mapping information (e.g. chosen \code{delta}, objectives)
  \item \code{grid}: grid definitions used by likelihood approximation
}
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(ldmppr_fit)}: Print a brief summary of a fitted model.

\item \code{coef(ldmppr_fit)}: Extract the estimated parameter vector.

\item \code{logLik(ldmppr_fit)}: Log-likelihood at the optimum.

\item \code{summary(ldmppr_fit)}: Summarize a fitted model.

\item \code{plot(ldmppr_fit)}: Plot diagnostics for a fitted model.

\item \code{as_nloptr(ldmppr_fit)}: Extract the underlying \code{nloptr} result.

}}
\section{Functions}{
\itemize{
\item \code{print(summary.ldmppr_fit)}: Print a summary produced by \code{\link{summary.ldmppr_fit}}.

\item \code{as_nloptr()}: Extract the underlying \code{nloptr} result.

}}
