% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosineTopics.R
\name{cosineTopics}
\alias{cosineTopics}
\title{Pairwise Cosine Similarities}
\usage{
cosineTopics(topics, progress = TRUE, pm.backend, ncpus)
}
\arguments{
\item{topics}{[\code{named matrix}]\cr
The counts of vocabularies/words (row wise) in topics (column wise).}

\item{progress}{[\code{logical(1)}]\cr
Should a nice progress bar be shown? Turning it off, could lead to significantly
faster calculation. Default is \code{TRUE}.
If \code{pm.backend} is set, parallelization is done and no progress bar will be shown.}

\item{pm.backend}{[\code{character(1)}]\cr
One of "multicore", "socket" or "mpi".
If \code{pm.backend} is set, \code{\link[parallelMap]{parallelStart}} is
called before computation is started and \code{\link[parallelMap]{parallelStop}}
is called after.}

\item{ncpus}{[\code{integer(1)}]\cr
Number of (physical) CPUs to use. If \code{pm.backend} is passed,
default is determined by \code{\link[parallelly]{availableCores}}.}
}
\value{
[\code{named list}] with entries
\describe{
  \item{\code{sims}}{[\code{lower triangular named matrix}] with all pairwise
  similarities of the given topics.}
  \item{\code{wordslimit}}{[\code{integer}] = vocabulary size. See
  \code{\link{jaccardTopics}} for original purpose.}
  \item{\code{wordsconsidered}}{[\code{integer}] = vocabulary size. See
  \code{\link{jaccardTopics}} for original purpose.}
  \item{\code{param}}{[\code{named list}] with parameter
  \code{type} [\code{character(1)}] \code{= "Cosine Similarity"}.}
}
}
\description{
Calculates the similarity of all pairwise topic combinations using the
Cosine Similarity.
}
\details{
The Cosine Similarity for two topics \eqn{\bm z_{i}} and \eqn{\bm z_{j}}
is calculated by
\deqn{ \cos(\theta | \bm z_{i}, \bm z_{j}) = \frac{ \sum_{v=1}^{V}{n_{i}^{(v)} n_{j}^{(v)}} }{ \sqrt{\sum_{v=1}^{V}{\left(n_{i}^{(v)}\right)^2}} \sqrt{\sum_{v=1}^{V}{\left(n_{j}^{(v)}\right)^2}} }}
with \eqn{\theta} determining the angle between the corresponding
count vectors \eqn{\bm z_{i}} and \eqn{\bm z_{j}},
\eqn{V} is the vocabulary size and \eqn{n_k^{(v)}} is the count of
assignments of the \eqn{v}-th word to the \eqn{k}-th topic.
}
\examples{
res = LDARep(docs = reuters_docs, vocab = reuters_vocab, n = 4, K = 10, num.iterations = 30)
topics = mergeTopics(res, vocab = reuters_vocab)
cosine = cosineTopics(topics)
cosine

sim = getSimilarity(cosine)
dim(sim)

}
\seealso{
Other TopicSimilarity functions: 
\code{\link{dendTopics}()},
\code{\link{getSimilarity}()},
\code{\link{jaccardTopics}()},
\code{\link{jsTopics}()},
\code{\link{rboTopics}()}
}
\concept{TopicSimilarity functions}
