% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Riccati}
\alias{Riccati}
\title{Solver for Riccati equation}
\usage{
Riccati(M, S, tol = 1e-08, maxiter = 10000L)
}
\arguments{
\item{M}{matrix}

\item{S}{matrix}

\item{tol}{double for tolerance}

\item{maxiter}{integer, the maximum number of iterations}
}
\value{
a list containing
\itemize{
\item \code{solution} matrix solution to Riccati's equation
\item \code{error} numerical error
\item \code{niter} number of iteration
\item \code{convergence} bool indicating convergence (\code{TRUE}) if \code{niter < maxiter}
}
}
\description{
Given two matrices \code{M} and \code{S}, solve Riccati equation by iterative updating to find the solution \eqn{\mathbf{R}}, where the latter satisfies
\deqn{\mathbf{R}=\mathbf{M}\mathbf{R}\mathbf{M}^\top + \mathbf{S}}
until convergence (i.e., when the Frobenius norm is less than \code{tol}, or the maximum number of iterations \code{maxiter} is reached.
}
