% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-persistence.R
\name{save_model_config}
\alias{save_model_config}
\alias{load_model_config}
\title{Save and load model configuration as JSON}
\usage{
save_model_config(model, filepath = NULL, overwrite = FALSE)

load_model_config(filepath, custom_objects = NULL)
}
\arguments{
\item{model}{Model object to save}

\item{filepath}{path to json file with the model config.}

\item{overwrite}{Whether we should overwrite any existing model configuration json
at \code{filepath}, or instead ask the user
via an interactive prompt.}

\item{custom_objects}{Optional named list mapping names to custom classes or
functions to be considered during deserialization.}
}
\value{
This is called primarily for side effects. \code{model} is returned,
invisibly, to enable usage with the pipe.
}
\description{
Save and re-load models configurations as JSON. Note that the representation
does not include the weights, only the architecture.
}
\details{
Note: \code{save_model_config()} serializes the model to JSON using
\code{serialize_keras_object()}, not \code{get_config()}. \code{serialize_keras_object()}
returns a superset of \code{get_config()}, with additional information needed to
create the class object needed to restore the model. See example for how to
extract the \code{get_config()} value from a saved model.
}
\section{Example}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{model <- keras_model_sequential(input_shape = 10) |> layer_dense(10)
file <- tempfile("model-config-", fileext = ".json")
save_model_config(model, file)

# load a new model instance with the same architecture but different weights
model2 <- load_model_config(file)

stopifnot(exprs = \{
  all.equal(get_config(model), get_config(model2))

  # To extract the `get_config()` value from a saved model config:
  all.equal(
      get_config(model),
      structure(jsonlite::read_json(file)$config,
                "__class__" = keras_model_sequential()$`__class__`)
  )
\})
}\if{html}{\out{</div>}}
}

\seealso{
Other saving and loading functions: \cr
\code{\link{export_savedmodel.keras.src.models.model.Model}()} \cr
\code{\link{layer_tfsm}()} \cr
\code{\link{load_model}()} \cr
\code{\link{load_model_weights}()} \cr
\code{\link{register_keras_serializable}()} \cr
\code{\link{save_model}()} \cr
\code{\link{save_model_weights}()} \cr
\code{\link{with_custom_object_scope}()} \cr
}
\concept{saving and loading functions}
