% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joinless_multiple.R
\name{joinless_multiple}
\alias{joinless_multiple}
\title{Infer relationship types between one dataset and multiple counterparts}
\usage{
joinless_multiple(
  x,
  ys,
  x_vars = NULL,
  y_vars = NULL,
  dataset_names = NULL,
  ...
)
}
\arguments{
\item{x}{A data frame. The reference dataset to compare from.}

\item{ys}{A named or unnamed list of data frames. Each element is treated
as a separate target dataset to compare \code{x} against.}

\item{x_vars}{Optional character vector of column names in \code{x} to compare.
Passed directly to \code{\link[=joinless]{joinless()}}. If \code{NULL}, the default behavior of
\code{\link[=joinless]{joinless()}} is used (i.e., it selects up to \code{max_vars} variables).}

\item{y_vars}{Optional character vector of column names to use in each
target dataset. If not \code{NULL}, the function filters \code{y_vars} to those
that exist in each dataset in \code{ys} before calling \code{\link[=joinless]{joinless()}}. If
\code{NULL}, each dataset is allowed to use its own default variable selection
in \code{\link[=joinless]{joinless()}} (up to \code{max_vars}).}

\item{dataset_names}{Optional character vector with labels for each dataset
in \code{ys}. If \code{NULL} and \code{ys} is a named list, the list names are used
(empty names are replaced by \code{"y1"}, \code{"y2"}, …). If \code{ys} is unnamed,
generic names \code{"y1"}, \code{"y2"}, … are generated. The length of
\code{dataset_names} must match the length of \code{ys} if supplied.}

\item{...}{Additional arguments passed on to \code{\link[=joinless]{joinless()}}, such as
\code{conf}, \code{error}, \code{n_x}, \code{n_y}, \code{max_vars}, \code{ignore}, \code{missingness_tol},
\code{type_coerce}, \code{seed}, \code{verbose}, and \code{info}.}
}
\value{
A data frame that row-binds the result of \code{\link[=joinless]{joinless()}} for all
target datasets that were processed. It contains all columns returned by
\code{\link[=joinless]{joinless()}} plus an additional column:
\itemize{
\item \code{dataset}: identifier of the target dataset (one per element of \code{ys}).
}

If all datasets are skipped, an empty data frame is returned.
}
\description{
This function is a convenience wrapper around \code{\link[=joinless]{joinless()}} that compares
a single dataset \code{x} against multiple datasets supplied in a list \code{ys}.
Internally it calls \code{\link[=joinless]{joinless()}} once per dataset and row-binds the results,
adding an extra column that identifies the target dataset.
}
\details{
For each dataset in \code{ys}, the function:
\itemize{
\item optionally restricts the variables in \code{x} via \code{x_vars},
\item optionally restricts the variables in that dataset via \code{y_vars},
\item calls \code{\link[=joinless]{joinless()}} with the provided settings,
\item tags the output with a dataset name.
}

When \code{y_vars} is not \code{NULL}, the function intersects \code{y_vars} with the
column names of each dataset in \code{ys}. This means that:
\itemize{
\item Variables listed in \code{y_vars} but missing in a given dataset are silently
dropped for that dataset.
\item If \emph{none} of the variables in \code{y_vars} exist in a particular dataset,
that dataset is skipped and a warning is emitted.
}

This behavior avoids producing \code{"error_type"} rows solely due to missing
columns in some of the target datasets.

If all datasets are skipped (e.g., because none contain the requested
\code{y_vars}), the function returns an empty data frame.
}
\examples{
df_base <- data.frame(id = 1:5, value = 1:5)
df_a <- data.frame(id = 3:7, value = 3:7)
df_b <- data.frame(id_alt = 1:5, value = 11:15)

# Compare the same key from df_base against multiple datasets
res <- joinless_multiple(
  x = df_base,
  ys = list(a = df_a, b = df_b),
  x_vars = "id",
  y_vars = c("id", "id_alt"),
  info = TRUE
)

}
