% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iv_functions.R
\name{coef.iv_fit}
\alias{coef.iv_fit}
\alias{confint.iv_fit}
\title{Extracts point estimates and confidence intervals of an \code{iv_fit} model.}
\usage{
\method{coef}{iv_fit}(object, parm = "iv", ...)

\method{confint}{iv_fit}(object, parm = c("iv", "fs", "rf"), level, ...)
}
\arguments{
\item{object}{an object of class \code{\link{iv_fit}}.}

\item{parm}{which estimate to return. Options are \code{"iv"} for instrumental variable estimate, \code{"fs"} for the first-stage estimate and \code{"rf"} for the reduced-form estimate.}

\item{...}{arguments passed to other methods.}

\item{level}{coverage level (i.e, 1-alpha). If not provided, it uses the same level as the one provided in \code{\link{iv_fit}}.}
}
\value{
\code{coef} returns a numeric vector with the estimates of interest.

\code{confint} returns a numeric vector with the confidence interval of interest.
}
\description{
The function \code{coef} extracts point estimates of an \code{\link{iv_fit}} model.

The function \code{confint} extracts confidence intervals of an \code{\link{iv_fit}} model.
}
\examples{
# prepare data
data("card")
y <- card$lwage
d <- card$educ
z <- card$nearc4
x <- model.matrix( ~ exper + expersq + black + south + smsa + reg661 + reg662 +
                     reg663 + reg664 + reg665+ reg666 + reg667 + reg668 + smsa66,
                   data = card)

# fit iv model
card.fit <- iv_fit(y, d, z, x)

# extract coefficients
coef(card.fit)
coef(card.fit, parm = "fs")
coef(card.fit, parm = "rf")

# extract confidence intervals
confint(card.fit)
confint(card.fit, parm = "fs")
confint(card.fit, parm = "rf")

}
