% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_level1_fup_uc.R
\name{extract_level1_fup_uc}
\alias{extract_level1_fup_uc}
\title{Extract level 1 ultracentrifugation \insertCite{redgrave1975separation}{invitroTKstats} data from wide level 0 file}
\usage{
extract_level1_fup_uc(
  data.set,
  chem.name,
  area.col.num,
  ISTD.name,
  ISTD.offset = 2,
  analysis.method = "GC",
  instrument = "Something or Other 3000",
  inst.param.offset = -3,
  conc.offset = -2,
  area.base = "Area...",
  inst.param.base = "RT...",
  conc.base = "Final Conc....",
  id.cols = c("Name", "Data File", "Acq. Date-Time"),
  type.indicator.col = "Name",
  AF.type.str = "AF",
  T1.type.str = "T1",
  T5.type.str = "T5",
  CC.type.str = "CC"
)
}
\arguments{
\item{data.set}{(Data Frame) A data frame containing a sheet of data for conversion.}

\item{chem.name}{(Character) A string giving the lab name of the chemical analyzed. The
value provided is used for all rows in the output data frame.}

\item{area.col.num}{(Numeric) An integer indicating which column of data.set contains
the MS feature area for the chemical.}

\item{ISTD.name}{(Character) A string indicating the internal standard used. The
value provided is used for all rows in the output data frame.}

\item{ISTD.offset}{(Numeric) An integer indicating how many columns difference there
is between the chemical of study MS area and the ISTD MS area. (Defaults to 2.)}

\item{analysis.method}{(Character) A string describing the chemical analysis method. The
value provided is used for all rows in the output data frame. 
(Defaults to "GC", that is gas chromatography.)}

\item{instrument}{(Character) A string describing the instrument used for chemical 
analysis. The value provided is used for all rows in the output data frame. 
(Defaults to "Something or Other 3000".)}

\item{inst.param.offset}{(Numeric) An integer indicating the difference in the number
of columns between the MS peak area and the column giving the instrument
parameters. (Defaults to -3.)}

\item{conc.offset}{(Numeric) An integer indicating the difference in the number
of columns between the MS peak area and the column giving the intended
concentration for calibration curves. (Defaults to -2.)}

\item{area.base}{(Character) A character string used for forming the name of MS
feature area column names (used for both test chemical and ISTD). (Defaults to
"Area...".)}

\item{inst.param.base}{(Character) A character string used for forming the name of the
chemical analysis instrument parameter column name. (Defaults to "RT...".)}

\item{conc.base}{(Character) A character string used for forming the name of the
calibration curve intended concentration column name. (Defaults to
"Final Conc....".)}

\item{id.cols}{(Character Vector) A vector of character strings used for identifying each
sample. (Defaults to c("Name", "Data File", "Type", "Acq. Date-Time").)}

\item{type.indicator.col}{(Character) A character string indicating which column of 
data.set contains the type of observation. (Defaults to "Name".)}

\item{AF.type.str}{(Character) String used to annotate observation of this type: Aqueous Fraction. 
(Defaults to "AF".)}

\item{T1.type.str}{(Character) String used to annotate observation of this type: Whole Plasma T1h Sample. 
(Defaults to "T1".)}

\item{T5.type.str}{(Character) String used to annotate observation of this type: Whole Plasma T5h Sample. 
(Defaults to "T5".)}

\item{CC.type.str}{(Character) String used to annotate observation of this type: Calibration Curve. 
(Defaults to "CC".)}
}
\value{
\item{data.frame}{A data.frame in standardized "level1" format}
}
\description{
This function extracts data from a Microsoft Excel file containing many
columns corresponding to different types of data.
}
\details{
The data frame of observations should be annotated according to
of these types:
\tabular{rrrrr}{
  Calibration Curve \tab CC\cr
  Ultracentrifugation Aqueous Fraction \tab AF\cr
  Whole Plasma T1h Sample  \tab T1\cr
  Whole Plasma T5h Sample \tab T5\cr
}
}
\references{
\insertRef{redgrave1975separation}{invitroTKstats}
}
\author{
John Wambaugh
}
