% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_parameters_bayesian.R,
%   R/find_parameters_brms.R
\name{find_parameters.BGGM}
\alias{find_parameters.BGGM}
\alias{find_parameters.brmsfit}
\title{Find names of model parameters from Bayesian models}
\usage{
\method{find_parameters}{BGGM}(x, component = "correlation", flatten = FALSE, ...)

\method{find_parameters}{brmsfit}(
  x,
  effects = "all",
  component = "all",
  flatten = FALSE,
  parameters = NULL,
  ...
)
}
\arguments{
\item{x}{A fitted model.}

\item{component}{Which type of parameters to return, such as parameters for
the conditional model, the zero-inflated part of the model, the dispersion
term, the instrumental variables or marginal effects be returned? Applies to
models with zero-inflated and/or dispersion formula, or to models with
instrumental variables (so called fixed-effects regressions), or models with
marginal effects (from \strong{mfx}). See details in section \emph{Model Components}
.May be abbreviated. Note that the \emph{conditional} component also refers to the
\emph{count} or \emph{mean} component - names may differ, depending on the modeling
package. There are three convenient shortcuts (not applicable to \emph{all} model
classes):
\itemize{
\item \code{component = "all"} returns all possible parameters.
\item If \code{component = "location"}, location parameters such as \code{conditional},
\code{zero_inflated}, \code{smooth_terms}, or \code{instruments} are returned (everything
that are fixed or random effects - depending on the \code{effects} argument -
but no auxiliary parameters).
\item For \code{component = "distributional"} (or \code{"auxiliary"}), components like
\code{sigma}, \code{dispersion}, \code{beta} or \code{precision} (and other auxiliary
parameters) are returned.
}}

\item{flatten}{Logical, if \code{TRUE}, the values are returned as character
vector, not as list. Duplicated values are removed.}

\item{...}{Currently not used.}

\item{effects}{Should variables for fixed effects (\code{"fixed"}), random effects
(\code{"random"}) or both (\code{"all"}) be returned? Only applies to mixed models. May
be abbreviated.

For models of from packages \strong{brms} or \strong{rstanarm} there are additional
options:
\itemize{
\item \code{"fixed"} returns fixed effects.
\item \code{"random_variance"} return random effects parameters (variance and
correlation components, e.g. those parameters that start with \code{sd_} or
\code{cor_}).
\item \code{"grouplevel"} returns random effects group level estimates, i.e. those
parameters that start with \code{r_}.
\item \code{"random"} returns both \code{"random_variance"} and \code{"grouplevel"}.
\item \code{"all"} returns fixed effects and random effects variances.
\item \code{"full"} returns all parameters.
}}

\item{parameters}{Regular expression pattern that describes the parameters that
should be returned.}
}
\value{
A list of parameter names. For simple models, only one list-element,
\code{conditional}, is returned. For more complex models, the returned list may
have following elements:
\itemize{
\item \code{conditional}, the "fixed effects" part from the model
\item \code{random}, the "random effects" part from the model
\item \code{zero_inflated}, the "fixed effects" part from the zero-inflation component
of the model. For \strong{brms}, this is named \code{zi}.
\item \code{zero_inflated_random}, the "random effects" part from the zero-inflation
component of the model. For \strong{brms}, this is named \code{zi_random}.
\item \code{smooth_terms}, the smooth parameters
}

Furthermore, some models, especially from \strong{brms}, can also return other
auxiliary (distributional) parameters. These may be one of the following:
\itemize{
\item \code{sigma}, the residual standard deviation (auxiliary parameter)
\item \code{dispersion}, the dispersion parameters (auxiliary parameter)
\item \code{beta}, the beta parameter (auxiliary parameter)
\item and any pre-defined or arbitrary distributional parameter for models from
package \strong{brms}, like \code{mu}, \code{ndt}, \code{kappa}, etc.
}

Models of class \strong{BGGM} additionally can return the elements \code{correlation}
and \code{intercept}.

Models of class \strong{BFBayesFactor} additionally can return the element
\code{extra}.
}
\description{
Returns the names of model parameters, like they typically
appear in the \code{summary()} output. For Bayesian models, the parameter
names equal the column names of the posterior samples after coercion
from \code{as.data.frame()}.
}
\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
find_parameters(m)
}
