% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata_tables.R
\name{get_metadata_tables_operation}
\alias{get_metadata_tables_operation}
\title{Get all tables for a given operation}
\usage{
get_metadata_tables_operation(
  operation = NULL,
  det = 0,
  tip = NULL,
  geo = NULL,
  lang = "ES",
  page = 0,
  validate = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{operation}{(string): code of the operation. To obtain a list of
available operations see \code{\link[=get_metadata_operations]{get_metadata_operations()}}.}

\item{det}{(int): level of detail. Valid values: 0, 1 or 2.}

\item{tip}{(string): set to 'A' for friendly output (e.g. readable dates),
set to 'M' to include metadata or set to 'AM' for both.}

\item{geo}{(int): set to 0 for national tables or set to 1 for tables with
a greater level of disaggregation.}

\item{lang}{(string): language of the retrieved data. Set to 'ES' for Spanish or set to 'EN' for English}

\item{page}{(int): page number. The retrieved result of the query is paginated (page=0 retrieves all pages).}

\item{validate}{(logical): validate input parameters. A FALSE value means fewer API calls.}

\item{verbose}{(logical): print additional information, including the URL to call the API service.}
}
\value{
Data frame with information of the available tables according to the operation specified in the function
}
\description{
Get all tables for a given operation
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get all the tables of the "IPC" operation
df <- get_metadata_tables_operation(operation = "IPC", validate = FALSE)
head(df)
\dontshow{\}) # examplesIf}
}
