% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cbs_index.R
\name{read_cbs_index}
\alias{read_cbs_index}
\title{Read a CBS index data file to a tibble}
\usage{
read_cbs_index(
  path,
  year,
  index_type = c("ses", "peri"),
  unit_type = c("muni", "yishuv", "sa"),
  cols = NULL,
  col_names = NULL
)
}
\arguments{
\item{path}{A character vector of length 1, denoting the local file path to the
CBS index data file. A full list of available files by the CBS is at the
relevant CBS page for either \href{https://www.cbs.gov.il/he/subjects/Pages/\%D7\%9E\%D7\%93\%D7\%93-\%D7\%97\%D7\%91\%D7\%A8\%D7\%AA\%D7\%99-\%D7\%9B\%D7\%9C\%D7\%9B\%D7\%9C\%D7\%99-\%D7\%A9\%D7\%9C-\%D7\%94\%D7\%A8\%D7\%A9\%D7\%95\%D7\%99\%D7\%95\%D7\%AA-\%D7\%94\%D7\%9E\%D7\%A7\%D7\%95\%D7\%9E\%D7\%99\%D7\%95\%D7\%AA.aspx}{Socio-Economic Status (SES)}
or for \href{https://www.cbs.gov.il/he/subjects/Pages/\%D7\%9E\%D7\%93\%D7\%93-\%D7\%A4\%D7\%A8\%D7\%99\%D7\%A4\%D7\%A8\%D7\%99\%D7\%90\%D7\%9C\%D7\%99\%D7\%95\%D7\%AA-\%D7\%A9\%D7\%9C-\%D7\%A8\%D7\%A9\%D7\%95\%D7\%99\%D7\%95\%D7\%AA-\%D7\%9E\%D7\%A7\%D7\%95\%D7\%9E\%D7\%99\%D7\%95\%D7\%AA.aspx}{peripheral level}.}

\item{year}{A numeric vector of length 1 denoting which year the data file
pointed in \code{path} is for. Be aware that the year in question is the year
\strong{the data is for}, not the year \strong{the data was published in}.}

\item{index_type}{A character vector of length 1, one of \code{c("ses", "peri")}.}

\item{unit_type}{A character vector of length 1, one of \code{c("muni", "yishuv", "sa")}.
\itemize{
\item \code{"muni"} - every row is a municipality.
\item \code{"yishuv"} - every row is a yishuv. In some years and indices this includes all yishuvim,
in others only yishuvim within regional councils.
\item \code{"sa"} - every row is a statistical area within a city or local council.
}}

\item{cols}{<\href{https://dplyr.tidyverse.org/reference/dplyr_tidy_select.html}{tidy-select}>
Columns to keep. The default \code{NULL} keeps all columns.}

\item{col_names}{A character vector containing the new column names of the
output tibble. If \code{NULL} then the tibble uses the original column names.
Must be the same length as the number of columns picked in \code{cols}.}
}
\value{
A tibble with CBS index data for a specific year, where every row is a
\code{unit_type} and every column is a different variable for this \code{unit_type} in
that year. Be advised all columns are of type character, so you need to parse
the data types yourself at will. Column names are merged from the relevant headers,
and only single whitespaces are kept. Rows with more than 90\% empty cells (usually
rows with non-data notes) are removed.
}
\description{
This function is a wrapper around \code{readxl::read_excel()}, reading a specific
CBS index data file for a specific year and a specific data domain. Its added
value is in its pre-defined parameters for every year and its specific quirks
in the Excel headers. For advanced users,the full set of options is available
with \code{il.cbs.muni:::df_cbs_index_params}.
}
\examples{
read_cbs_index(
  path = system.file("extdata", "24_22_375t1.xlsx", package = "il.cbs.muni"),
  year = 2019,
  index_type = "ses",
  unit_type = "muni"
) |>
  dplyr::glimpse()
}
