% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_krbc2pu.R
\name{calc_krbc2pu}
\alias{calc_krbc2pu}
\title{Back-calculates the Red Blood Cell to Unbound Plasma Partition Coefficient}
\usage{
calc_krbc2pu(
  Rb2p,
  Funbound.plasma,
  hematocrit = NULL,
  default.to.human = FALSE,
  species = "Human",
  suppress.messages = TRUE
)
}
\arguments{
\item{Rb2p}{The chemical blood:plasma concentration ratop}

\item{Funbound.plasma}{The free fraction of chemical in the presence of 
plasma protein
Rblood2plasma.}

\item{hematocrit}{Overwrites default hematocrit value in calculating
Rblood2plasma.}

\item{default.to.human}{Substitutes missing animal values with human values
if true.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{suppress.messages}{Determine whether to display certain usage
feedback.}
}
\value{
The red blood cell to unbound chemical in plasma partition coefficient.
}
\description{
Given an observed ratio of chemical concentration in blood to plasma, this
function calculates a Red Blood Cell to unbound plasma (Krbc2pu) partition
coefficient that would be consistent with that observation.
}
\references{
\insertRef{pearce2017evaluation}{httk}

\insertRef{ruark2014predicting}{httk}
}
\author{
John Wambaugh and Robert Pearce
}
\keyword{Parameter}
