% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_formulas.R
\name{make_formulas}
\alias{make_formulas}
\title{Process formulas and store in nested list}
\usage{
make_formulas(input_forms, var_names, par_names, n_states)
}
\arguments{
\item{input_forms}{Nested list of formulas, with two levels: observed variable, 
and parameter of the observation distribution. The formulas can contain 
state-specific terms, e.g. "~ state1(x1) + x2".}

\item{var_names}{character vector name of each observation variable}

\item{par_names}{list with element for each observation variable that
contains character vector of name of each parameter in its distribution}

\item{n_states}{Number of states}
}
\value{
Nested list of formulas, with three levels: observed variable,
parameter of the observation distribution, and state.
}
\description{
Process formulas and store in nested list
}
\details{
Formulas for the observation parameters can be different for the
different states, using special functions of the form "state1", "state2", etc.
This method processes the list of formulas passed by the user to extract the 
state-specific formulas. Missing formulas are assumed to be intercept-only ~1.
}
\examples{
input_forms <- list(step = list(shape = ~ state1(x1) + x2,
                                scale = ~ x1),
                    count = list(lambda = ~ state1(x1) + state2(s(x2, bs = "cs"))))

make_formulas(input_forms = input_forms, 
              var_names = names(input_forms), 
              par_names = lapply(input_forms, names), 
              n_states = 2)
              
}
