% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadData.R
\name{loadData}
\alias{loadData}
\title{Load and Normalize Hi-C Data}
\usage{
loadData(files, index, chromosome, normalize = TRUE)
}
\arguments{
\item{files}{character vector. Paths to Hi-C matrices in bed format.}

\item{index}{character. A path to an index file in bed format.}

\item{chromosome}{character or integer. Chromosome to select.}

\item{normalize}{logical. Whether or not to normalize the output (with MA
method). Set to \code{TRUE} by default.}
}
\value{
An \code{\link[InteractionSet]{InteractionSet}} corresponding to all
interactions present in at least one of the input matrices and corresponding
counts across all matrices.
}
\description{
This function loads data necessary for the analysis and outputs
them in a suitable format for \code{performTest} and \code{2Dclust}.
}
\examples{
replicates <- 1:2
cond <- "90"
allBegins <- interaction(expand.grid(replicates, cond), sep = "-")
allBegins <- as.character(allBegins)
chromosome <- 1
nbChr <- 1
allMat <- sapply(allBegins, function(ab) {
  matFile <- paste0("Rep", ab, "-chr", chromosome, "_200000.bed")
  })
index <- system.file("extdata", "index.200000.longest18chr.abs.bed",
                    package = "hicream")
                    format <- rep("HiC-Pro", length(replicates) * length(cond) * nbChr)
binsize <- 200000
files <- system.file("extdata", unlist(allMat), package = "hicream")
exData <- loadData(files, index, chromosome, normalize = TRUE)
}
\author{
Élise Jorge \email{elise.jorge@inrae.fr}\cr
Sylvain Foissac \email{sylvain.foissac@inrae.fr}\cr
Toby Dylan Hocking \email{toby.hocking@r-project.org}\cr
Pierre Neuvial \email{pierre.neuvial@math.univ-toulouse.fr}\cr
Nathalie Vialaneix \email{nathalie.vialaneix@inrae.fr}
}
