% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp_seq.R
\name{exp_seq}
\alias{exp_seq}
\title{exp_seq}
\usage{
exp_seq(n, ln = 15, exponent = 2, round_values = TRUE, rmv_extremes = TRUE)
}
\arguments{
\item{n}{The maximum value that the values in the sequence are scaled to.}

\item{ln}{How long the vector should be (defaults to 15).}

\item{exponent}{The exponential power with which to multiply the sequence by (defaults to 2).}

\item{round_values}{Option to round values to whole numbers (defaults to `TRUE`). If `n` equals 1,
round_values will automatically be set to FALSE.}

\item{rmv_extremes}{Option to remove zero and the maximum value (i.e. `n`) from the beginning
and the end of the returned vector (defaults to `FALSE`). Note that this will mean the length
of the returned vector will be `n` - 2.}
}
\value{
A vector containing exponentially increasing values between 0 and a specified value `n`.
}
\description{
Creates a vector of exponentially increasing values between 0 and a specified value `n`.
If `n` is specified as 1, the vector will be scaled to between 0 and 1.
}
\examples{
# Create sequence of length 8, scaled between 0 and 10000
exp_seq(10000,8)
# Set rmv_extremes = FALSE to get full sequence
exp_seq(10000,8,rmv_extremes = FALSE)
# The exponent defaults to 2. Setting it to between 1 and 2 causes it to converge on
# a linear sequence. When exponent is set to 1 the sequence increases linearly
exp_seq(10000,8,exponent=1)
# Setting it to greater than 2 will cause it the values in the sequence to shift towards zero
exp_seq(10000,8,exponent=4)

# Create sequence of length 12, scaled between 0 and 1
exp_seq(1,12)
exp_seq(1,12,rmv_extremes = FALSE)
exp_seq(1,12,exponent=1)
exp_seq(1,12,exponent=4)

}
