% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/att.R
\name{att}
\alias{att}
\title{Estimating the ATT from an hbal object}
\usage{
att(hbalobject, method="lm_robust", dr=TRUE, displayAll=FALSE, alpha=0.9, ...)
}
\arguments{
\item{hbalobject}{an object of class \code{hbal} as returned by \code{hbal}.}

\item{method}{estimation method for the ATT. Default is the Lin (2016) estimator.}

\item{dr}{doubly robust, whether an outcome model is included in estimating the ATT.}

\item{displayAll}{only displays treatment effect by default.}

\item{alpha}{tuning paramter for glmnet}

\item{...}{arguments passed to lm_lin or lm_robust}
}
\value{
A matrix of estimates with their robust standard errors
}
\description{
\code{att} estimates the average treatment effect on the treated (ATT) from an 
hbal object returned by \code{hbal}.
}
\details{
This is a wrapper for \code{lm_robust} and \code{lm_lin} from the \pkg{estimatr} package.
}
\examples{
#EXAMPLE 1
set.seed(1984)
N <- 500
X1 <- rnorm(N)
X2 <- rbinom(N,size=1,prob=.5)
X <- cbind(X1, X2)
treat <- rbinom(N, 1, prob=0.5) # Treatment indicator
y <- 0.5 * treat + X[,1] + X[,2] + rnorm(N) # Outcome
dat <- data.frame(treat=treat, X, Y=y)
out <- hbal(Treat = 'treat', X = c('X1', 'X2'), Y = 'Y', data=dat)
sout <- summary(att(out))
}
\author{
Yiqing Xu, Eddie Yang
}
