% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{manhattan}
\alias{manhattan}
\title{Manhattan Distance Function Factory}
\usage{
manhattan(dist = 1)
}
\arguments{
\item{dist}{threshold above which the function will return \code{FALSE}}
}
\value{
function that checks if Manhattan distance between two vectors
exceeds \code{dist}
}
\description{
Returns a function that checks whether the Manhattan distance between two
numeric vectors is less than or equal to a given threshold.
}
\examples{
# test data: Manhattan distance equals 2
x <- rep(0, 5)
y <- c(0, 1, 0, 0, 1)

# should return TRUE when checking Manhattan distance <= 3
dist_3 <- manhattan(3)
dist_3(x, y)

# should return FALSE when checking Manhattan distance <= 1
dist_1 <- manhattan(1)
dist_1(x, y)

}
