% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toInteger.R
\name{toInteger}
\alias{toInteger}
\title{Translate group sequential design to integer events (survival designs)
or sample size (other designs)}
\usage{
toInteger(x, ratio = x$ratio, roundUpFinal = TRUE)
}
\arguments{
\item{x}{An object of class \code{gsDesign} or \code{gsSurv}.}

\item{ratio}{Usually corresponds to experimental:control sample size ratio.
If an integer is provided, rounding is done to a multiple of
\code{ratio + 1}. See details.
If input is non integer, rounding is done to the nearest integer or
nearest larger integer depending on \code{roundUpFinal}.}

\item{roundUpFinal}{Sample size is rounded up to a value of \code{ratio + 1}
with the default \code{roundUpFinal = TRUE} if \code{ratio} is a
non-negative integer.
If \code{roundUpFinal = FALSE} and \code{ratio} is a non-negative integer,
sample size is rounded to the nearest multiple of \code{ratio + 1}.
For event counts, \code{roundUpFinal = TRUE} rounds final event count up;
otherwise, just rounded if \code{roundUpFinal = FALSE}.
See details.}
}
\value{
Output is an object of the same class as input \code{x}; i.e.,
  \code{gsDesign} with integer vector for \code{n.I} or \code{gsSurv}
  with integer vector \code{n.I} and integer total sample size. See details.
}
\description{
Translate group sequential design to integer events (survival designs)
or sample size (other designs)
}
\details{
It is useful to explicitly provide the argument \code{ratio} when a
\code{gsDesign} object is input since \code{gsDesign()} does not have a
\code{ratio} in return.
\code{ratio = 0, roundUpFinal = TRUE} will just round up the sample size
(also event count).
Rounding of event count targets is not impacted by \code{ratio}.
Since \code{x <- gsSurv(ratio = M)} returns a value for \code{ratio},
\code{toInteger(x)} will round to a multiple of \code{M + 1} if \code{M}
is a non-negative integer; otherwise, just rounding will occur.
The most common example would be if there is 1:1 randomization (2:1) and
the user wishes an even (multiple of 3) sample size, then \code{toInteger()}
will operate as expected.
To just round without concern for randomization ratio, set \code{ratio = 0}.
If \code{toInteger(x, ratio = 3)}, rounding for final sample size is done
to a multiple of 3 + 1 = 4; this could represent a 3:1 or 1:3
randomization ratio.
For 3:2 randomization, \code{ratio = 4} would ensure rounding sample size
to a multiple of 5.
}
\examples{
# The following code derives the group sequential design using the method
# of Lachin and Foulkes

x <- gsSurv(
  k = 3,                 # 3 analyses
  test.type = 4,         # Non-binding futility bound 1 (no futility bound) and 4 are allowable
  alpha = .025,          # 1-sided Type I error
  beta = .1,             # Type II error (1 - power)
  timing = c(0.45, 0.7), # Proportion of final planned events at interims
  sfu = sfHSD,           # Efficacy spending function
  sfupar = -4,           # Parameter for efficacy spending function
  sfl = sfLDOF,          # Futility spending function; not needed for test.type = 1
  sflpar = 0,            # Parameter for futility spending function
  lambdaC = .001,        # Exponential failure rate
  hr = 0.3,              # Assumed proportional hazard ratio (1 - vaccine efficacy = 1 - VE)
  hr0 = 0.7,             # Null hypothesis VE
  eta = 5e-04,           # Exponential dropout rate
  gamma = 10,            # Piecewise exponential enrollment rates
  R = 16,                # Time period durations for enrollment rates in gamma
  T = 24,                # Planned trial duration
  minfup = 8,            # Planned minimum follow-up
  ratio = 3              # Randomization ratio (experimental:control)
)
# Convert sample size to multiple of ratio + 1 = 4, round event counts.
# Default is to round up both event count and sample size for final analysis
toInteger(x)
}
