% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grmtree-print.R
\name{print.grmtree}
\alias{print.grmtree}
\title{Print Method for GRM Tree Objects}
\usage{
\method{print}{grmtree}(
  x,
  title = "Graded Response Model Tree",
  objfun = "negative log-likelihood",
  ...
)
}
\arguments{
\item{x}{A GRM tree object of class 'grmtree'.}

\item{title}{Character string specifying the title for the print output
(default: "Graded Response Model Tree").}

\item{objfun}{Character string labeling the objective function
(default: "negative log-likelihood").}

\item{...}{Additional arguments passed to \code{print.modelparty}.}
}
\value{
Invisibly returns the GRM tree object. Primarily called for its side
effect of printing a formatted summary.
}
\description{
Displays a formatted summary of a GRM (Graded Response Model) tree object.
This function extends \code{print.modelparty} from the partykit package with
specialized formatting for GRM trees.
}
\details{
The print method provides a comprehensive summary of the GRM tree,
including:
\itemize{
\item Model formula used for fitting
\item Tree structure with node information
\item Item parameter estimates for each terminal node
\item Confidence intervals for parameters
\item Group parameters (mean and covariance)
\item Summary statistics (number of nodes, objective function value)
}
}
\examples{
\donttest{
library(grmtree)
library(hlt)
data("asti", package = "hlt")
asti$resp <- data.matrix(asti[, 1:4])

# Fit GRM tree
tree <- grmtree(resp ~ gender + group,
                data = asti,
                control = grmtree.control(minbucket = 30))

# Print the tree summary
print(tree)

# Alternative syntax (automatically calls print.grmtree)
tree
}

}
\seealso{
\code{\link[partykit]{print.modelparty}} for the underlying printing
infrastructure, \code{\link{grmtree}} for creating GRM tree objects
}
