% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth-estimates.R
\name{spline_values2}
\alias{spline_values2}
\title{Evaluate a spline at provided covariate values}
\usage{
spline_values2(
  smooth,
  data,
  model,
  unconditional,
  overall_uncertainty = TRUE,
  frequentist = FALSE
)
}
\arguments{
\item{smooth}{currently an object that inherits from class \code{mgcv.smooth}.}

\item{data}{an optional data frame of values to evaluate \code{smooth} at.}

\item{model}{a fitted model; currently only \code{\link[mgcv:gam]{mgcv::gam()}} and \code{\link[mgcv:bam]{mgcv::bam()}}
models are supported.}

\item{unconditional}{logical; should confidence intervals include the
uncertainty due to smoothness selection? If \code{TRUE}, the corrected Bayesian
covariance matrix will be used.}

\item{overall_uncertainty}{logical; should the uncertainty in the model
constant term be included in the standard error of the evaluate values of
the smooth?}

\item{frequentist}{logical; use the frequentist covariance matrix?}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

The function \code{spline_values2()} has been renamed to \code{spline_values()} as of
version 0.9.0. This was allowed following the removal of \code{evaluate_smooth()},
which was the only function using \code{spline_values()}. So \code{spline_values2()}
has been renamed to \code{spline_values()}.
}
\keyword{internal}
