% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_validation.R
\name{createLeavePersonsOutFolds}
\alias{createLeavePersonsOutFolds}
\title{Create Leave-persons-out Folds}
\usage{
createLeavePersonsOutFolds(gpModel, k = 10)
}
\arguments{
\item{gpModel}{object of class GPPM.}

\item{k}{integer scalar. Number of folds to create.}
}
\value{
A fold vector, which is a vector of length \code{nrow(getData(gpModel))} of integers from 1 to k. If \code{foldVector[i]=j}, then data point i is assigned to fold j.
}
\description{
This function is used to create a leave-persons-out cross-validation fold vector to be used by \code{\link{crossvalidate}}.
}
\details{
The folds are created such that the data of each person is fully in one fold.
}
\examples{
\donttest{
data("demoLGCM")
lgcm <- gppm(
  "muI+muS*t", "varI+covIS*(t+t#)+varS*t*t#+(t==t#)*sigma",
  demoLGCM, "ID", "y"
)
theFolds <- createLeavePersonsOutFolds(lgcm)
}

}
\seealso{
\code{\link{crossvalidate}} for how to use the created fold vector to perform cross-validation.
}
