% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{glmstarma_sim.control}
\alias{glmstarma_sim.control}
\title{Control Parameters for Simulation of \code{glmstarma} Models}
\usage{
glmstarma_sim.control(
  return_burn_in = FALSE,
  init_link = "parameter",
  use_sparsity = TRUE,
  sparsity_threshold = 2/3
)
}
\arguments{
\item{return_burn_in}{Logical; if \code{TRUE}, include the burn-in period in the returned simulated data. Default is \code{FALSE}.}

\item{init_link}{Character or matrix. Method to initialize first link values in the burn-in period. See details.}

\item{use_sparsity}{Logical; whether to use sparse matrices for the neighborhood matrices.}

\item{sparsity_threshold}{Numeric in \eqn{[0, 1]}. Threshold for proportion of non-zero elements for considering neighborhood matrices as sparse (default: \code{2/3}).}
}
\value{
A named list of control parameters
}
\description{
List of control parameters to be passed to the \code{glmstarma.sim} function.
}
\details{
This function validates control arguments for \code{glmstarma.sim}.
By default, the initial link values for the burn-in period are generated by calculating the unconditional mean of the process based on the model parameters, ignoring covariates.
Different initial link values can submitted as a numeric matrix, with \eqn{p} rows (number of locations) and \code{max_time_lag} columns (maximum time lag of the model).
}
\seealso{
\code{\link{glmstarma.sim}}, \code{\link{glmstarma.control}}
}
