% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive.R
\name{geom_edge_interactive}
\alias{geom_edge_interactive}
\title{layer to draw edges of a network interactively}
\usage{
geom_edge_interactive(
  mapping = NULL,
  data = NULL,
  geom = ggiraph::geom_segment_interactive,
  ...
)
}
\arguments{
\item{mapping}{aesthetic mapping, default is NULL}

\item{data}{data to plot, default is NULL}

\item{geom}{geometric layer to draw lines}

\item{...}{additional parameter passed to 'geom'}
}
\value{
line segments layer
}
\description{
layer to draw edges of a network interactively
}
\examples{
library(ggiraph)
flow_info <- data.frame(from = LETTERS[c(1,2,3,3,4,5,6)],
                        to = LETTERS[c(5,5,5,6,7,6,7)])

dd <- data.frame(
    label = LETTERS[1:7],
    v1 = abs(rnorm(7)),
    v2 = abs(rnorm(7)),
    v3 = abs(rnorm(7))
)

g = igraph::graph_from_data_frame(flow_info)

p <- ggplot(g)  + geom_edge_interactive()
library(ggplot2)
library(scatterpie)

p2 <- p \%<+\% dd +
    geom_scatterpie(cols = c("v1", "v2", "v3")) +
    geom_text_interactive(aes(label=label, tooltip = label, data_id = label), nudge_y = .2) +
    coord_fixed()

girafe(ggobj = p2)
}
