% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_edge_shape.R
\name{scale_edge_shape}
\alias{scale_edge_shape}
\alias{scale_edge_shape_discrete}
\alias{scale_edge_shape_continuous}
\alias{scale_edge_shape_binned}
\alias{scale_edge_shape_manual}
\alias{scale_edge_shape_identity}
\title{Edge shape scales}
\usage{
scale_edge_shape(..., solid = TRUE)

scale_edge_shape_discrete(..., solid = TRUE)

scale_edge_shape_continuous(...)

scale_edge_shape_binned(..., solid = TRUE)

scale_edge_shape_manual(..., values, breaks = waiver(), na.value = NA)

scale_edge_shape_identity(..., guide = "none")
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[ggplot2:discrete_scale]{discrete_scale}}
  \describe{
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale values
\item A character vector that defines possible values of the scale and their
order
\item A function that accepts the existing (automatic) values and returns
new ones. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{drop}}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} includes the levels in the factor. Please note that to display
every level in a legend, the layer should use \code{show.legend = TRUE}.}
    \item{\code{na.translate}}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
    \item{\code{na.value}}{If \code{na.translate = TRUE}, what aesthetic value should the
missing values be displayed as? Does not apply to position scales
where \code{NA} is always placed at the far right.}
    \item{\code{minor_breaks}}{One of:
\itemize{
\item \code{NULL} for no minor breaks
\item \code{waiver()} for the default breaks (none for discrete, one minor break
between each major break for continuous)
\item A numeric vector of positions
\item A function that given the limits returns a vector of minor breaks. Also
accepts rlang \link[rlang:as_function]{lambda} function notation. When
the function has two arguments, it will be given the limits and major
break positions.
}}
    \item{\code{labels}}{One of the options below. Please note that when \code{labels} is a
vector, it is highly recommended to also set the \code{breaks} argument as a
vector to protect against unintended mismatches.
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{guide}}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}
    \item{\code{call}}{The \code{call} used to construct the scale for reporting messages.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}

\item{solid}{Should the shapes be solid, \code{TRUE}, or hollow,
\code{FALSE}?}

\item{values}{a set of aesthetic values to map data values to. The values
will be matched in order (usually alphabetical) with the limits of the
scale, or with \code{breaks} if provided. If this is a named vector, then the
values will be matched based on the names instead. Data values that don't
match will be given \code{na.value}.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output
}}

\item{na.value}{The aesthetic value to use for missing (\code{NA}) values}

\item{guide}{Guide to use for this scale.}
}
\value{
A ggproto object inheriting from \code{Scale}
}
\description{
This set of scales defines new shape scales for edge geoms equivalent to the
ones already defined by ggplot2. See \code{\link[ggplot2:scale_shape]{ggplot2::scale_shape()}} for
more information. The different geoms will know whether to use edge scales or
the standard scales so it is not necessary to write \code{edge_shape} in
the call to the geom - just use \code{shape}.
}
\seealso{
Other scale_edge_*: 
\code{\link{scale_edge_alpha}()},
\code{\link{scale_edge_colour}},
\code{\link{scale_edge_fill}},
\code{\link{scale_edge_linetype}()},
\code{\link{scale_edge_size}()},
\code{\link{scale_edge_width}()},
\code{\link{scale_label_size}()}
}
\concept{scale_edge_*}
