% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_rope_ext_inplace}
\alias{ggml_rope_ext_inplace}
\title{Extended RoPE Inplace (Graph)}
\usage{
ggml_rope_ext_inplace(
  ctx,
  a,
  b,
  c = NULL,
  n_dims,
  mode = 0L,
  n_ctx_orig = 0L,
  freq_base = 10000,
  freq_scale = 1,
  ext_factor = 0,
  attn_factor = 1,
  beta_fast = 32,
  beta_slow = 1
)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}

\item{b}{Position tensor (int32)}

\item{c}{Optional frequency factors tensor (NULL for default)}

\item{n_dims}{Number of dimensions to apply rotation to}

\item{mode}{RoPE mode}

\item{n_ctx_orig}{Original context length the model was trained on}

\item{freq_base}{Base frequency for RoPE (default 10000 for most models)}

\item{freq_scale}{Frequency scale factor (1.0 = no scaling)}

\item{ext_factor}{YaRN extension factor (0.0 to disable)}

\item{attn_factor}{Attention scale factor (typically 1.0)}

\item{beta_fast}{YaRN parameter for fast dimensions}

\item{beta_slow}{YaRN parameter for slow dimensions}
}
\value{
View of input tensor with RoPE applied in place
}
\description{
Creates a graph node for extended RoPE, modifying input tensor in place.
Returns a view of the input tensor.
}
\seealso{
Other rope: 
\code{\link{ggml_rope_multi}()},
\code{\link{ggml_rope_multi_inplace}()}
}
\concept{rope}
