% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_gelu_erf}
\alias{ggml_gelu_erf}
\title{Exact GELU Activation (Graph)}
\usage{
ggml_gelu_erf(ctx, a)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}
}
\value{
Tensor representing the exact GELU operation
}
\description{
Creates a graph node for exact GELU using the error function (erf).
GELU(x) = x * 0.5 * (1 + erf(x / sqrt(2))).
More accurate than approximate GELU but potentially slower on some backends.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
ggml_set_f32(a, c(-2, -1, 0, 1, 2))
r <- ggml_gelu_erf(ctx, a)
graph <- ggml_build_forward_expand(ctx, r)
ggml_graph_compute(ctx, graph)
result <- ggml_get_f32(r)
ggml_free(ctx)
}
}
