% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05-mosaicing.R
\name{create_raster_mosaic}
\alias{create_raster_mosaic}
\title{Create raster mosaic with intelligent file selection}
\usage{
create_raster_mosaic(
  input_data,
  method = "merge",
  region_boundary = NULL,
  output_file = NULL,
  parallel = FALSE
)
}
\arguments{
\item{input_data}{Character vector of file paths, directory path, or list of rasters}

\item{method}{Mosaicing method: "merge", "mosaic", "mean", "max", "min"}

\item{region_boundary}{Optional region boundary for clipping}

\item{output_file}{Optional output file path}

\item{parallel}{Use parallel processing}
}
\value{
SpatRaster object
}
\description{
Create mosaics from multiple raster files with various methods and
intelligent file selection based on region boundaries.
}
\examples{
\dontrun{
# These examples require external data files not included with the package
# Basic mosaic
mosaic <- create_raster_mosaic("/path/to/rasters", method = "merge")

# Mosaic for specific region
ohio_mosaic <- create_raster_mosaic("/aster/files", "merge", "Ohio")

# Mean composite
mean_mosaic <- create_raster_mosaic(raster_list, method = "mean")
}

}
