% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{g_binary_op}
\alias{g_binary_op}
\alias{g_intersection}
\alias{g_union}
\alias{g_difference}
\alias{g_sym_difference}
\title{Binary operations on WKB or WKT geometries}
\usage{
g_intersection(
  this_geom,
  other_geom,
  as_wkb = TRUE,
  as_iso = FALSE,
  byte_order = "LSB",
  quiet = FALSE
)

g_union(
  this_geom,
  other_geom,
  as_wkb = TRUE,
  as_iso = FALSE,
  byte_order = "LSB",
  quiet = FALSE
)

g_difference(
  this_geom,
  other_geom,
  as_wkb = TRUE,
  as_iso = FALSE,
  byte_order = "LSB",
  quiet = FALSE
)

g_sym_difference(
  this_geom,
  other_geom,
  as_wkb = TRUE,
  as_iso = FALSE,
  byte_order = "LSB",
  quiet = FALSE
)
}
\arguments{
\item{this_geom}{Either a raw vector of WKB or list of raw vectors, or a
character vector containing one or more WKT strings.}

\item{other_geom}{Either a raw vector of WKB or list of raw vectors, or a
character vector containing one or more WKT strings. Must contain the same
number of geometries as \code{this_geom}.}

\item{as_wkb}{Logical value, \code{TRUE} to return the output geometry in WKB
format (the default), or \code{FALSE} to return as WKT.}

\item{as_iso}{Logical value, \code{TRUE} to export as ISO WKB/WKT (ISO 13249
SQL/MM Part 3), or \code{FALSE} (the default) to export as "Extended WKB/WKT".}

\item{byte_order}{Character string specifying the byte order when output is
WKB. One of \code{"LSB"} (the default) or \code{"MSB"} (uncommon).}

\item{quiet}{Logical value, \code{TRUE} to suppress warnings. Defaults to \code{FALSE}.}
}
\value{
A geometry as WKB raw vector or WKT string, or a list/character vector of
geometries as WKB/WKT with length equal to the number of input geometry
pairs.
\code{NULL} (\code{as_wkb = TRUE}) / \code{NA} (\code{as_wkb = FALSE}) is returned with a
warning if WKB input cannot be converted into an OGR geometry object, or if
an error occurs in the call to the underlying OGR API function.
}
\description{
These functions implement operations on pairs of geometries in OGC WKB
or WKT format.
}
\details{
These functions use the GEOS library via GDAL headers.

\code{g_intersection()} returns a new geometry which is the region of
intersection of the two geometries operated on. \code{g_intersects()} can be used
to test if two geometries intersect.

\code{g_union()} returns a new geometry which is the region of
union of the two geometries operated on.

\code{g_difference()} returns a new geometry which is the region of this geometry
with the region of the other geometry removed.

\code{g_sym_difference()} returns a new geometry which is the symmetric
difference of this geometry and the other geometry (union minus
intersection).
}
\note{
\code{this_geom} and \code{other_geom} are assumed to be in the same coordinate
reference system.

Geometry validity is not checked. In case you are unsure of the validity
of the input geometries, call \code{g_is_valid()} before, otherwise the result
might be wrong.
}
\examples{
elev_file <- system.file("extdata/storml_elev.tif", package="gdalraster")
ds <- new(GDALRaster, elev_file)
g1 <- ds$bbox() |> bbox_to_wkt()
ds$close()

g2 <- "POLYGON ((327381.9 5104541.2, 326824.0 5104092.5, 326708.8 5103182.9,
  327885.2 5102612.9, 329334.5 5103322.4, 329304.2 5104474.5,328212.7
  5104656.4, 328212.7 5104656.4, 327381.9 5104541.2))"

# see spatial predicate defintions at https://en.wikipedia.org/wiki/DE-9IM
g_intersects(g1, g2)  # TRUE
g_overlaps(g1, g2)  # TRUE
# therefore,
g_contains(g1, g2)  # FALSE

g_sym_difference(g1, g2) |> g_area()

g3 <- g_intersection(g1, g2)
g4 <- g_union(g1, g2)
g_difference(g4, g3) |> g_area()
}
