test_that("RunningStats works", {
    set.seed(42)
    rs <- new(RunningStats, na_rm=TRUE)
    expect_output(show(rs),"RunningStats")
    chunk <- runif(1000)
    rs$update(chunk)
    expect_equal(rs$get_count(), length(chunk))
    expect_equal(rs$get_mean(), mean(chunk))
    expect_equal(rs$get_min(), min(chunk))
    expect_equal(rs$get_max(), max(chunk))
    expect_equal(rs$get_var(), var(chunk))
    expect_equal(rs$get_sd(), sd(chunk))
    chunk2 <- runif(1000)
    rs$update(chunk2)
    expect_equal(rs$get_count(), 2000)
    chunk3 <- (c(rep(NA, 10), runif(10)))
    rs$update(chunk3)
    expect_equal(rs$get_count(), 2010)
    expect_equal(rs$get_mean(), mean(c(chunk,chunk2,chunk3), na.rm=TRUE))
    rs$reset()
    expect_equal(rs$get_count(), 0)
    expect_equal(rs$get_sum(), 0)
    expect_true(is.na(rs$get_mean()))
    expect_true(is.na(rs$get_var()))
    expect_true(is.na(rs$get_sd()))
    expect_equal(rs$get_min(), Inf)
    expect_equal(rs$get_max(), -Inf)
})
