% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_data.R
\name{plot_chr}
\alias{plot_chr}
\title{Plot chromatogram}
\usage{
plot_chr(
  data,
  scale = "log",
  dim = 2,
  floor = -1,
  title = "Intensity",
  xlab = "retention time 1",
  ylab = "retention time 2"
)
}
\arguments{
\item{data}{a \emph{list} object. Data extracted from a cdf file,
ideally the output from extract_data().}

\item{scale}{a \emph{string} object. Either 'linear' or 'log'. log refers to
logarithm base 10. Default is log scale.}

\item{dim}{a \emph{integer} object. The time dimensions of the plot, either 1
or 2. Default is 2.}

\item{floor}{a \emph{float} object. The floor value for plotting. Values
below floor will be scaled up. Default for linear plotting is 0, default for
log plotting is 10^3.}

\item{title}{a \emph{string} object. Title placed at the top of the plot.
Default title "Intensity".}

\item{xlab}{a \emph{string} object. Label for the x axis. Default is
"retention time 1".}

\item{ylab}{a \emph{string} object. Label for the y axis. Default is
"retention time 2".}
}
\value{
A \emph{ggplot} object. A contour plot of TIC data plotted in two
dimensional retention time.
}
\description{
\code{plot_chr} plots TIC data for chromatogram.
}
\details{
This function creates a contour plot using of TIC data vs the x and
y retention times using \code{\link[ggplot2]{ggplot}} from ggplot2 package
\insertCite{ggplot2}{gcxgclab}.
}
\examples{
file <- system.file("extdata","sample1.cdf",package="gcxgclab")
frame <- extract_data(file,mod_t=.5)
plot_chr(frame, title='Raw Data', scale="linear")
plot_chr(frame, title='Log Intensity')

}
\references{
\insertAllCited{}
}
