% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphing.R
\name{generatePlot}
\alias{generatePlot}
\title{Function that generate plots for metabolite models}
\usage{
generatePlot(
  graph,
  df,
  met_vec,
  covariates,
  grp = "Diet",
  models,
  save_path = NULL
)
}
\arguments{
\item{graph}{character string, 'None' by default. If not 'None, in addition to returning models, produces pdf file of graphs based on the specific value of 'graph'.}

\item{df}{Data frame containing columns Group(factor); ID(subject ID: character); Time(positive: numeric); other Time terms (numeric); other individidual characteristics covariates; as well columns of metabolite concentrations;
Note: All non-concentration columns must be complete (No missing values); concentration columns can have missing values in the forms of either numeric 0 or 'NA'.}

\item{met_vec}{the vector of metabolite names}

\item{covariates}{Vector containing the names of the "ID" covariate, grouping covariate and other covariates excluding any "Time" covariates;}

\item{grp}{is the grouping variable;}

\item{models}{a list of fitted non-linear mixed effects metabolite models}

\item{save_path}{location (file path, not directory) where the pdf file will be saved (must end in '.pdf'); default is NULL, i.e. pdf is saved to a temporary location}
}
\value{
A pdf file for fitted concenration curves that is saved to a user provided file location; otherwise saved to a temporary location
}
\description{
Function that generate plots for metabolite models
}
\examples{
\donttest{
require(gammaFuncModel)
require(dplyr)
require(nlme)
require(patchwork)
require(scales)
 df <- data.frame(
  ID = rep(sprintf("\%02d", 1:10), each = 9 * 3),  
  Time = rep(rep(1:9, each = 3), 10),             
  Diet = as.factor(rep(1:3, times = 9 * 10)),     
  Age = rep(sample(20:70, 10, replace = TRUE), each = 9 * 3), 
  BMI = round(rep(runif(10, 18.5, 35), each = 9 * 3), 1)     
)
metvar <- paste0("met", 1:10)
concentration_data <- replicate(10, round(runif(270, 5, 15), 2))
colnames(concentration_data) <- metvar[1:10]
df <- cbind(df, as.data.frame(concentration_data))
covariates <- c("ID", "Diet", "Age", "BMI")
mods <- generate_models(df = df, met_vec = metvar, covariates = covariates, graph = 'None')
generatePlot(
  graph = "individual_separated", 
  df = df, 
  met_vec = metvar, 
  covariates = covariates, 
  grp = "Diet", 
  models = mods,
  save_path = NULL
 )
}
}
\references{
Wickham, H. (2022). dplyr: A Grammar of Data Manipulation. R package version 1.0.10. 
Available at: \url{https://CRAN.R-project.org/package=dplyr}

Pinheiro, J. C., & Bates, D. M. (2022). nlme: Linear and Nonlinear Mixed Effects Models. R package version 3.1-153.
Available at: \url{https://CRAN.R-project.org/package=nlme}
}
