% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extendr-wrappers.R
\name{parent_aid}
\alias{parent_aid}
\title{Parent Adjustment Identification Distance between two DAG / CPDAG adjacency matrices}
\usage{
parent_aid(g_true, g_guess, edge_direction)
}
\arguments{
\item{g_true}{Adjacency matrix of the true graph}

\item{g_guess}{Adjacency matrix of the guess graph}

\item{edge_direction}{either "from row to column" or "from column to row"}
}
\value{
2-element vector of type double \cr c(normalized error in [0,1], total number of errors)
}
\description{
Computes the parent adjustment intervention distance between the true \code{g_true} DAG or CPDAG and an estimated \code{g_guess} DAG or CPDAG.
}
\details{
For details see Henckel, Würtzen, Weichwald (2024) \doi{doi:10.48550/arXiv.2402.08616} \cr
The source code is available at \href{https://github.com/CausalDisco/gadjid}{github.com/CausalDisco/gadjid}

Graph inputs are accepted as adjacency matrices of type double.
An adjacency matrix for a DAG may only contain 0s and 1s.
An adjacency matrix for a CPDAG may only contain 0s, 1s and 2s.
DAG and CPDAG inputs are validated for acyclicity.
However, for CPDAG inputs, \strong{the user needs to ensure the adjacency
matrix indeed codes a valid CPDAG (instead of just a PDAG)}.

If \code{edge_direction="from row to column"}, then
a \code{1} in row \code{r} and column \code{c} codes a directed edge ‘r → c’;
if \code{edge_direction="from column to row"}, then
a \code{1} in row \code{r} and column \code{c} codes a directed edge ‘c → r’;
for either setting of \code{edge_direction},
a \code{2} in row \code{r} and column \code{c} codes an undirected edge ‘r – c’
(an additional \code{2} in row \code{c} and column \code{r} is ignored;
one of the two entries is sufficient to code an undirected edge).
}
\examples{
full <- rbind(c(0, 1, 1, 1),
              c(0, 0, 1, 1),
              c(0, 0, 0, 1),
              c(0, 0, 0, 0))
chain <- rbind(c(0, 1, 0, 0),
               c(0, 0, 1, 0),
               c(0, 0, 0, 1),
               c(0, 0, 0, 0))
identical(parent_aid(full, chain, "from row to column"), c(4/12, 4))

}
\references{
L Henckel, T Würtzen, S Weichwald.
"Adjustment Identification Distance: A gadjid for Causal Structure Learning."
Proceedings of the 40th Conference on Uncertainty in Artificial Intelligence (UAI), 2024.
\doi{doi:10.48550/arXiv.2402.08616}
}
