% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brainview_magick.R
\name{arrange.brainview.images.grid}
\alias{arrange.brainview.images.grid}
\title{Combine several brainview images as a grid into a new figure.}
\usage{
arrange.brainview.images.grid(
  brainview_images,
  output_img,
  colorbar_img = NULL,
  silent = TRUE,
  num_per_row = 10L,
  border_geometry = "5x5",
  background_color = "white",
  captions = NULL
)
}
\arguments{
\item{brainview_images}{vector of character strings, paths to the brainview images, usually in PNG format}

\item{output_img}{path to output image that including the file extension}

\item{colorbar_img}{path to the main image containing the separate colorbar, usually an image in PNG format}

\item{silent}{logical, whether to suppress messages}

\item{num_per_row}{positive integer, the number of image tiles per row.}

\item{border_geometry}{string, a geometry string passed to \code{magick::image_border} to define the borders to add to each image tile. The default value adds 5 pixels, both horizontally and vertically.}

\item{background_color}{hex color string, such as "#DDDDDD" or "#FFFFFF". The color to use when extending images (e.g., when creating the border). WARNING: Do not use color names (like 'gray'), as their interpretation differs between rgl and image magick!}

\item{captions}{vector of character strings or NULL, the (optional) text annotations for the images. Useful to print the subject identifier onto the individual tiles. Length must match number of image tiles in 'brainview_images'.}
}
\value{
named list with entries: 'brainview_images': vector of character strings, the paths to the input images. 'output_img_path': character string, path to the output image. 'merged_img': the magick image instance.
}
\description{
Create a new image from several image tiles, the exact layout is a grid with n per row.
}
\note{
The tiles are written row-wise, in the order in which they occur in the parameter 'brainview_images'.
}
