% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw.R
\name{NR}
\alias{NR}
\title{The normal reference bandwidth selection for weighted data}
\usage{
NR(X, wt, ktype = "normal")
}
\arguments{
\item{X}{The numeric data vector.}

\item{wt}{The non-negative weight vector.}

\item{ktype}{A character string giving the type kernel to be used: "\code{normal}", "\code{epanechnikov}", "\code{biweight}", or "\code{triweight}". By default, the "\code{normal}" kernel is used.}
}
\value{
Returns the computed value for the bandwidth parameter.
}
\description{
This function computes the data-driven bandwidth for smoothing the ROC (or distribution) function using the NR method of Beyene and El Ghouch (2020). This is an extension of the classical (unweighted) normal reference bandwith selection method to the case of weighted data.
}
\details{
See Beyene and El Ghouch (2020) for details.
}
\references{
Beyene, K.M. and El Ghouch A. (2020). Smoothed time-dependent receiver operating characteristic curve for right censored survival data. \emph{Statistics in Medicine}. 39: 3373-3396.
}
\author{
Kassu Mehari Beyene, Catholic University of Louvain. \code{<kasu.beyene@uclouvain.be>}

Anouar El Ghouch, Catholic University of Louvain. \code{<anouar.elghouch@uclouvain.be>}
}
\keyword{internal}
