% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose.R
\name{compose}
\alias{compose}
\alias{mk_par}
\title{Set cell content from paragraph chunks}
\usage{
compose(x, i = NULL, j = NULL, value, part = "body", use_dot = FALSE)

mk_par(x, i = NULL, j = NULL, value, part = "body", use_dot = FALSE)
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{i}{row selector, see section \emph{Row selection with the \code{i} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{j}{column selector, see section \emph{Column selection with the \code{j} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{value}{a call to function \code{\link[=as_paragraph]{as_paragraph()}}.}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' can be used.}

\item{use_dot}{by default \code{use_dot=FALSE}; if \code{use_dot=TRUE},
\code{value} is evaluated within a data.frame augmented of a column named \code{.}
containing the \code{j}th column.}
}
\description{
Modify flextable displayed values with eventually
mixed content paragraphs.

Function is handling complex formatting as image insertion with
\code{\link[=as_image]{as_image()}}, superscript with \code{\link[=as_sup]{as_sup()}}, formated
text with \code{\link[=as_chunk]{as_chunk()}} and several other \emph{chunk} functions.

Function \code{mk_par} is another name for \code{compose} as
there is an unwanted \strong{conflict with package 'purrr'}.

If you only need to add some content at the end
or the beginning of paragraphs and keep existing
content as it is, functions \code{\link[=append_chunks]{append_chunks()}} and
\code{\link[=prepend_chunks]{prepend_chunks()}} should be prefered.
}
\examples{
ft_1 <- flextable(head(cars, n = 5), col_keys = c("speed", "dist", "comment"))
ft_1 <- mk_par(
  x = ft_1, j = "comment",
  i = ~ dist > 9,
  value = as_paragraph(
    colorize(as_i("speed: "), color = "gray"),
    as_sup(sprintf("\%.0f", speed))
  )
)
ft_1 <- set_table_properties(ft_1, layout = "autofit")
ft_1

# using `use_dot = TRUE` ----
set.seed(8)
dat <- iris[sample.int(n = 150, size = 10), ]
dat <- dat[order(dat$Species), ]


ft_2 <- flextable(dat)
ft_2 <- mk_par(ft_2,
  j = ~ . - Species,
  value = as_paragraph(
    minibar(.,
      barcol = "white",
      height = .1
    )
  ), use_dot = TRUE
)
ft_2 <- theme_vader(ft_2)
ft_2 <- autofit(ft_2)
ft_2
}
\seealso{
\code{\link[=fp_text_default]{fp_text_default()}}, \code{\link[=as_chunk]{as_chunk()}}, \code{\link[=as_b]{as_b()}}, \code{\link[=as_word_field]{as_word_field()}}, \code{\link[=labelizor]{labelizor()}}

Other functions for mixed content paragraphs: 
\code{\link{append_chunks}()},
\code{\link{as_paragraph}()},
\code{\link{prepend_chunks}()}
}
\concept{functions for mixed content paragraphs}
